package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AclRuleTopicResourceBuilder extends AclRuleTopicResourceFluentImpl<AclRuleTopicResourceBuilder> implements VisitableBuilder<AclRuleTopicResource,AclRuleTopicResourceBuilder> {

    AclRuleTopicResourceFluent<?> fluent;
    Boolean validationEnabled;

    public AclRuleTopicResourceBuilder() {
        this(true);
    }

    public AclRuleTopicResourceBuilder(Boolean validationEnabled) {
        this(new AclRuleTopicResource(), validationEnabled);
    }

    public AclRuleTopicResourceBuilder(AclRuleTopicResourceFluent<?> fluent) {
        this(fluent, true);
    }

    public AclRuleTopicResourceBuilder(AclRuleTopicResourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AclRuleTopicResource(), validationEnabled);
    }

    public AclRuleTopicResourceBuilder(AclRuleTopicResourceFluent<?> fluent,AclRuleTopicResource instance) {
        this(fluent, instance, true);
    }

    public AclRuleTopicResourceBuilder(AclRuleTopicResourceFluent<?> fluent,AclRuleTopicResource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withPatternType(instance.getPatternType());
        
        this.validationEnabled = validationEnabled; 
    }

    public AclRuleTopicResourceBuilder(AclRuleTopicResource instance) {
        this(instance,true);
    }

    public AclRuleTopicResourceBuilder(AclRuleTopicResource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withPatternType(instance.getPatternType());
        
        this.validationEnabled = validationEnabled; 
    }

    public AclRuleTopicResource build() {
        AclRuleTopicResource buildable = new AclRuleTopicResource();
        buildable.setName(fluent.getName());
        buildable.setPatternType(fluent.getPatternType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AclRuleTopicResourceBuilder that = (AclRuleTopicResourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
