package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AclRuleTransactionalIdResourceBuilder extends AclRuleTransactionalIdResourceFluentImpl<AclRuleTransactionalIdResourceBuilder> implements VisitableBuilder<AclRuleTransactionalIdResource,AclRuleTransactionalIdResourceBuilder> {

    AclRuleTransactionalIdResourceFluent<?> fluent;
    Boolean validationEnabled;

    public AclRuleTransactionalIdResourceBuilder() {
        this(true);
    }

    public AclRuleTransactionalIdResourceBuilder(Boolean validationEnabled) {
        this(new AclRuleTransactionalIdResource(), validationEnabled);
    }

    public AclRuleTransactionalIdResourceBuilder(AclRuleTransactionalIdResourceFluent<?> fluent) {
        this(fluent, true);
    }

    public AclRuleTransactionalIdResourceBuilder(AclRuleTransactionalIdResourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new AclRuleTransactionalIdResource(), validationEnabled);
    }

    public AclRuleTransactionalIdResourceBuilder(AclRuleTransactionalIdResourceFluent<?> fluent,AclRuleTransactionalIdResource instance) {
        this(fluent, instance, true);
    }

    public AclRuleTransactionalIdResourceBuilder(AclRuleTransactionalIdResourceFluent<?> fluent,AclRuleTransactionalIdResource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPatternType(instance.getPatternType());
        
        fluent.withName(instance.getName());
        
        this.validationEnabled = validationEnabled; 
    }

    public AclRuleTransactionalIdResourceBuilder(AclRuleTransactionalIdResource instance) {
        this(instance,true);
    }

    public AclRuleTransactionalIdResourceBuilder(AclRuleTransactionalIdResource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withPatternType(instance.getPatternType());
        
        this.withName(instance.getName());
        
        this.validationEnabled = validationEnabled; 
    }

    public AclRuleTransactionalIdResource build() {
        AclRuleTransactionalIdResource buildable = new AclRuleTransactionalIdResource();
        buildable.setPatternType(fluent.getPatternType());
        buildable.setName(fluent.getName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AclRuleTransactionalIdResourceBuilder that = (AclRuleTransactionalIdResourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
