package io.strimzi.api.kafka.model;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class CertSecretSourceFluentImpl<A extends CertSecretSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CertSecretSourceFluent<A> {

    private String secretName;
    private String certificate;

    public CertSecretSourceFluentImpl() {
    }

    public CertSecretSourceFluentImpl(CertSecretSource instance) {
        this.withSecretName(instance.getSecretName());
        
        this.withCertificate(instance.getCertificate());
    }

    public String getSecretName() {
        return this.secretName;
    }

    public A withSecretName(String secretName) {
        this.secretName=secretName; return (A) this;
    }

    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    public A withNewSecretName(StringBuilder arg1) {
        return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(int[] arg1,int arg2,int arg3) {
        return (A)withSecretName(new String(arg1, arg2, arg3));
    }

    public A withNewSecretName(char[] arg1) {
        return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(StringBuffer arg1) {
        return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(byte[] arg1,int arg2) {
        return (A)withSecretName(new String(arg1, arg2));
    }

    public A withNewSecretName(byte[] arg1) {
        return (A)withSecretName(new String(arg1));
    }

    public A withNewSecretName(char[] arg1,int arg2,int arg3) {
        return (A)withSecretName(new String(arg1, arg2, arg3));
    }

    public A withNewSecretName(byte[] arg1,int arg2,int arg3) {
        return (A)withSecretName(new String(arg1, arg2, arg3));
    }

    public A withNewSecretName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withSecretName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewSecretName(String arg1) {
        return (A)withSecretName(new String(arg1));
    }

    public String getCertificate() {
        return this.certificate;
    }

    public A withCertificate(String certificate) {
        this.certificate=certificate; return (A) this;
    }

    public Boolean hasCertificate() {
        return this.certificate != null;
    }

    public A withNewCertificate(StringBuilder arg1) {
        return (A)withCertificate(new String(arg1));
    }

    public A withNewCertificate(int[] arg1,int arg2,int arg3) {
        return (A)withCertificate(new String(arg1, arg2, arg3));
    }

    public A withNewCertificate(char[] arg1) {
        return (A)withCertificate(new String(arg1));
    }

    public A withNewCertificate(StringBuffer arg1) {
        return (A)withCertificate(new String(arg1));
    }

    public A withNewCertificate(byte[] arg1,int arg2) {
        return (A)withCertificate(new String(arg1, arg2));
    }

    public A withNewCertificate(byte[] arg1) {
        return (A)withCertificate(new String(arg1));
    }

    public A withNewCertificate(char[] arg1,int arg2,int arg3) {
        return (A)withCertificate(new String(arg1, arg2, arg3));
    }

    public A withNewCertificate(byte[] arg1,int arg2,int arg3) {
        return (A)withCertificate(new String(arg1, arg2, arg3));
    }

    public A withNewCertificate(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCertificate(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCertificate(String arg1) {
        return (A)withCertificate(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CertSecretSourceFluentImpl that = (CertSecretSourceFluentImpl) o;
        if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
        if (certificate != null ? !certificate.equals(that.certificate) :that.certificate != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(secretName,  certificate,  super.hashCode());
    }

}
