package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class CertificateAuthorityFluentImpl<A extends CertificateAuthorityFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CertificateAuthorityFluent<A> {

    private int validityDays;
    private boolean generateCertificateAuthority;
    private boolean generateSecretOwnerReference;
    private int renewalDays;
    private CertificateExpirationPolicy certificateExpirationPolicy;

    public CertificateAuthorityFluentImpl() {
    }

    public CertificateAuthorityFluentImpl(CertificateAuthority instance) {
        this.withValidityDays(instance.getValidityDays());
        
        this.withGenerateCertificateAuthority(instance.isGenerateCertificateAuthority());
        
        this.withGenerateSecretOwnerReference(instance.isGenerateSecretOwnerReference());
        
        this.withRenewalDays(instance.getRenewalDays());
        
        this.withCertificateExpirationPolicy(instance.getCertificateExpirationPolicy());
    }

    public int getValidityDays() {
        return this.validityDays;
    }

    public A withValidityDays(int validityDays) {
        this.validityDays=validityDays; return (A) this;
    }

    public Boolean hasValidityDays() {
        return true;
    }

    public boolean isGenerateCertificateAuthority() {
        return this.generateCertificateAuthority;
    }

    public A withGenerateCertificateAuthority(boolean generateCertificateAuthority) {
        this.generateCertificateAuthority=generateCertificateAuthority; return (A) this;
    }

    public Boolean hasGenerateCertificateAuthority() {
        return true;
    }

    public boolean isGenerateSecretOwnerReference() {
        return this.generateSecretOwnerReference;
    }

    public A withGenerateSecretOwnerReference(boolean generateSecretOwnerReference) {
        this.generateSecretOwnerReference=generateSecretOwnerReference; return (A) this;
    }

    public Boolean hasGenerateSecretOwnerReference() {
        return true;
    }

    public int getRenewalDays() {
        return this.renewalDays;
    }

    public A withRenewalDays(int renewalDays) {
        this.renewalDays=renewalDays; return (A) this;
    }

    public Boolean hasRenewalDays() {
        return true;
    }

    public CertificateExpirationPolicy getCertificateExpirationPolicy() {
        return this.certificateExpirationPolicy;
    }

    public A withCertificateExpirationPolicy(CertificateExpirationPolicy certificateExpirationPolicy) {
        this.certificateExpirationPolicy=certificateExpirationPolicy; return (A) this;
    }

    public Boolean hasCertificateExpirationPolicy() {
        return this.certificateExpirationPolicy != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CertificateAuthorityFluentImpl that = (CertificateAuthorityFluentImpl) o;
        if (validityDays != that.validityDays) return false;
        if (generateCertificateAuthority != that.generateCertificateAuthority) return false;
        if (generateSecretOwnerReference != that.generateSecretOwnerReference) return false;
        if (renewalDays != that.renewalDays) return false;
        if (certificateExpirationPolicy != null ? !certificateExpirationPolicy.equals(that.certificateExpirationPolicy) :that.certificateExpirationPolicy != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(validityDays,  generateCertificateAuthority,  generateSecretOwnerReference,  renewalDays,  certificateExpirationPolicy,  super.hashCode());
    }

}
