package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ContainerEnvVarBuilder extends ContainerEnvVarFluentImpl<ContainerEnvVarBuilder> implements VisitableBuilder<ContainerEnvVar,ContainerEnvVarBuilder> {

    ContainerEnvVarFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerEnvVarBuilder() {
        this(true);
    }

    public ContainerEnvVarBuilder(Boolean validationEnabled) {
        this(new ContainerEnvVar(), validationEnabled);
    }

    public ContainerEnvVarBuilder(ContainerEnvVarFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerEnvVarBuilder(ContainerEnvVarFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ContainerEnvVar(), validationEnabled);
    }

    public ContainerEnvVarBuilder(ContainerEnvVarFluent<?> fluent,ContainerEnvVar instance) {
        this(fluent, instance, true);
    }

    public ContainerEnvVarBuilder(ContainerEnvVarFluent<?> fluent,ContainerEnvVar instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withValue(instance.getValue());
        
        this.validationEnabled = validationEnabled; 
    }

    public ContainerEnvVarBuilder(ContainerEnvVar instance) {
        this(instance,true);
    }

    public ContainerEnvVarBuilder(ContainerEnvVar instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withValue(instance.getValue());
        
        this.validationEnabled = validationEnabled; 
    }

    public ContainerEnvVar build() {
        ContainerEnvVar buildable = new ContainerEnvVar();
        buildable.setName(fluent.getName());
        buildable.setValue(fluent.getValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerEnvVarBuilder that = (ContainerEnvVarBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
