package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.balancing.BrokerCapacityBuilder;
import io.strimzi.api.kafka.model.balancing.BrokerCapacityFluentImpl;
import io.strimzi.api.kafka.model.balancing.BrokerCapacity;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.template.CruiseControlTemplateBuilder;
import io.strimzi.api.kafka.model.template.CruiseControlTemplate;
import java.lang.StringBuffer;

public class CruiseControlSpecFluentImpl<A extends CruiseControlSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CruiseControlSpecFluent<A> {

    private String image;
    private TlsSidecarBuilder tlsSidecar;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private JvmOptionsBuilder jvmOptions;
    private VisitableBuilder<? extends Logging,?> logging;
    private CruiseControlTemplateBuilder template;
    private BrokerCapacityBuilder brokerCapacity;
    private Map<String,Object> config;
    private Map<String,Object> metrics;
    private VisitableBuilder<? extends MetricsConfig,?> metricsConfig;

    public CruiseControlSpecFluentImpl() {
    }

    public CruiseControlSpecFluentImpl(CruiseControlSpec instance) {
        this.withImage(instance.getImage());
        
        this.withTlsSidecar(instance.getTlsSidecar());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withLogging(instance.getLogging());
        
        this.withTemplate(instance.getTemplate());
        
        this.withBrokerCapacity(instance.getBrokerCapacity());
        
        this.withConfig(instance.getConfig());
        
        this.withMetrics(instance.getMetrics());
        
        this.withMetricsConfig(instance.getMetricsConfig());
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(int[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(char[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(byte[] arg1,int arg2) {
        return (A)withImage(new String(arg1, arg2));
    }

    public A withNewImage(byte[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(char[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTlsSidecar instead.
 * @return The buildable object.
 */
@Deprecated public TlsSidecar getTlsSidecar() {
        return this.tlsSidecar!=null?this.tlsSidecar.build():null;
    }

    public TlsSidecar buildTlsSidecar() {
        return this.tlsSidecar!=null?this.tlsSidecar.build():null;
    }

    public A withTlsSidecar(TlsSidecar tlsSidecar) {
        _visitables.get("tlsSidecar").remove(this.tlsSidecar);
        if (tlsSidecar!=null){ this.tlsSidecar= new TlsSidecarBuilder(tlsSidecar); _visitables.get("tlsSidecar").add(this.tlsSidecar);} return (A) this;
    }

    public Boolean hasTlsSidecar() {
        return this.tlsSidecar != null;
    }

    public CruiseControlSpecFluent.TlsSidecarNested<A> withNewTlsSidecar() {
        return new TlsSidecarNestedImpl();
    }

    public CruiseControlSpecFluent.TlsSidecarNested<A> withNewTlsSidecarLike(TlsSidecar item) {
        return new TlsSidecarNestedImpl(item);
    }

    public CruiseControlSpecFluent.TlsSidecarNested<A> editTlsSidecar() {
        return withNewTlsSidecarLike(getTlsSidecar());
    }

    public CruiseControlSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecar() {
        return withNewTlsSidecarLike(getTlsSidecar() != null ? getTlsSidecar(): new TlsSidecarBuilder().build());
    }

    public CruiseControlSpecFluent.TlsSidecarNested<A> editOrNewTlsSidecarLike(TlsSidecar item) {
        return withNewTlsSidecarLike(getTlsSidecar() != null ? getTlsSidecar(): item);
    }

    public ResourceRequirements getResources() {
        return this.resources;
    }

    public A withResources(ResourceRequirements resources) {
        this.resources=resources; return (A) this;
    }

    public Boolean hasResources() {
        return this.resources != null;
    }

    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public Probe buildLivenessProbe() {
        return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(Probe livenessProbe) {
        _visitables.get("livenessProbe").remove(this.livenessProbe);
        if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public CruiseControlSpecFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    public CruiseControlSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    public CruiseControlSpecFluent.LivenessProbeNested<A> editLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe());
    }

    public CruiseControlSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new ProbeBuilder().build());
    }

    public CruiseControlSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public Probe buildReadinessProbe() {
        return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(Probe readinessProbe) {
        _visitables.get("readinessProbe").remove(this.readinessProbe);
        if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds) {
        return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public CruiseControlSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    public CruiseControlSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    public CruiseControlSpecFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe());
    }

    public CruiseControlSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new ProbeBuilder().build());
    }

    public CruiseControlSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    
/**
 * This method has been deprecated, please use method buildJvmOptions instead.
 * @return The buildable object.
 */
@Deprecated public JvmOptions getJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public JvmOptions buildJvmOptions() {
        return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public A withJvmOptions(JvmOptions jvmOptions) {
        _visitables.get("jvmOptions").remove(this.jvmOptions);
        if (jvmOptions!=null){ this.jvmOptions= new JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} return (A) this;
    }

    public Boolean hasJvmOptions() {
        return this.jvmOptions != null;
    }

    public CruiseControlSpecFluent.JvmOptionsNested<A> withNewJvmOptions() {
        return new JvmOptionsNestedImpl();
    }

    public CruiseControlSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item) {
        return new JvmOptionsNestedImpl(item);
    }

    public CruiseControlSpecFluent.JvmOptionsNested<A> editJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions());
    }

    public CruiseControlSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions() {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): new JvmOptionsBuilder().build());
    }

    public CruiseControlSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item) {
        return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public Logging getLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public Logging buildLogging() {
        return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(Logging logging) {
        if (logging instanceof ExternalLogging){ this.logging= new ExternalLoggingBuilder((ExternalLogging)logging); _visitables.get("logging").add(this.logging);}
        if (logging instanceof InlineLogging){ this.logging= new InlineLoggingBuilder((InlineLogging)logging); _visitables.get("logging").add(this.logging);}
        return (A) this;
    }

    public Boolean hasLogging() {
        return this.logging != null;
    }

    public A withExternalLogging(ExternalLogging externalLogging) {
        _visitables.get("logging").remove(this.logging);
        if (externalLogging!=null){ this.logging= new ExternalLoggingBuilder(externalLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public CruiseControlSpecFluent.ExternalLoggingNested<A> withNewExternalLogging() {
        return new ExternalLoggingNestedImpl();
    }

    public CruiseControlSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item) {
        return new ExternalLoggingNestedImpl(item);
    }

    public A withInlineLogging(InlineLogging inlineLogging) {
        _visitables.get("logging").remove(this.logging);
        if (inlineLogging!=null){ this.logging= new InlineLoggingBuilder(inlineLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public CruiseControlSpecFluent.InlineLoggingNested<A> withNewInlineLogging() {
        return new InlineLoggingNestedImpl();
    }

    public CruiseControlSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item) {
        return new InlineLoggingNestedImpl(item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public CruiseControlTemplate getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public CruiseControlTemplate buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(CruiseControlTemplate template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new CruiseControlTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate() {
        return this.template != null;
    }

    public CruiseControlSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    public CruiseControlSpecFluent.TemplateNested<A> withNewTemplateLike(CruiseControlTemplate item) {
        return new TemplateNestedImpl(item);
    }

    public CruiseControlSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public CruiseControlSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new CruiseControlTemplateBuilder().build());
    }

    public CruiseControlSpecFluent.TemplateNested<A> editOrNewTemplateLike(CruiseControlTemplate item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    
/**
 * This method has been deprecated, please use method buildBrokerCapacity instead.
 * @return The buildable object.
 */
@Deprecated public BrokerCapacity getBrokerCapacity() {
        return this.brokerCapacity!=null?this.brokerCapacity.build():null;
    }

    public BrokerCapacity buildBrokerCapacity() {
        return this.brokerCapacity!=null?this.brokerCapacity.build():null;
    }

    public A withBrokerCapacity(BrokerCapacity brokerCapacity) {
        _visitables.get("brokerCapacity").remove(this.brokerCapacity);
        if (brokerCapacity!=null){ this.brokerCapacity= new BrokerCapacityBuilder(brokerCapacity); _visitables.get("brokerCapacity").add(this.brokerCapacity);} return (A) this;
    }

    public Boolean hasBrokerCapacity() {
        return this.brokerCapacity != null;
    }

    public CruiseControlSpecFluent.BrokerCapacityNested<A> withNewBrokerCapacity() {
        return new BrokerCapacityNestedImpl();
    }

    public CruiseControlSpecFluent.BrokerCapacityNested<A> withNewBrokerCapacityLike(BrokerCapacity item) {
        return new BrokerCapacityNestedImpl(item);
    }

    public CruiseControlSpecFluent.BrokerCapacityNested<A> editBrokerCapacity() {
        return withNewBrokerCapacityLike(getBrokerCapacity());
    }

    public CruiseControlSpecFluent.BrokerCapacityNested<A> editOrNewBrokerCapacity() {
        return withNewBrokerCapacityLike(getBrokerCapacity() != null ? getBrokerCapacity(): new BrokerCapacityBuilder().build());
    }

    public CruiseControlSpecFluent.BrokerCapacityNested<A> editOrNewBrokerCapacityLike(BrokerCapacity item) {
        return withNewBrokerCapacityLike(getBrokerCapacity() != null ? getBrokerCapacity(): item);
    }

    public A addToConfig(String key,Object value) {
        if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap<String,Object>(); }
        if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(Map<String,Object> map) {
        if(this.config == null && map != null) { this.config = new LinkedHashMap<String,Object>(); }
        if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(String key) {
        if(this.config == null) { return (A) this; }
        if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(Map<String,Object> map) {
        if(this.config == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getConfig() {
        return this.config;
    }

    public <K extends Object,V extends Object>A withConfig(Map<String,Object> config) {
        if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap<String,Object>(config);} return (A) this;
    }

    public Boolean hasConfig() {
        return this.config != null;
    }

    public A addToMetrics(String key,Object value) {
        if(this.metrics == null && key != null && value != null) { this.metrics = new LinkedHashMap<String,Object>(); }
        if(key != null && value != null) {this.metrics.put(key, value);} return (A)this;
    }

    public A addToMetrics(Map<String,Object> map) {
        if(this.metrics == null && map != null) { this.metrics = new LinkedHashMap<String,Object>(); }
        if(map != null) { this.metrics.putAll(map);} return (A)this;
    }

    public A removeFromMetrics(String key) {
        if(this.metrics == null) { return (A) this; }
        if(key != null && this.metrics != null) {this.metrics.remove(key);} return (A)this;
    }

    public A removeFromMetrics(Map<String,Object> map) {
        if(this.metrics == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.metrics != null){this.metrics.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getMetrics() {
        return this.metrics;
    }

    public <K extends Object,V extends Object>A withMetrics(Map<String,Object> metrics) {
        if (metrics == null) { this.metrics =  null;} else {this.metrics = new LinkedHashMap<String,Object>(metrics);} return (A) this;
    }

    public Boolean hasMetrics() {
        return this.metrics != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetricsConfig instead.
 * @return The buildable object.
 */
@Deprecated public MetricsConfig getMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public MetricsConfig buildMetricsConfig() {
        return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public A withMetricsConfig(MetricsConfig metricsConfig) {
        if (metricsConfig instanceof JmxPrometheusExporterMetrics){ this.metricsConfig= new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics)metricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);}
        return (A) this;
    }

    public Boolean hasMetricsConfig() {
        return this.metricsConfig != null;
    }

    public A withJmxPrometheusExporterMetricsConfig(JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig) {
        _visitables.get("metricsConfig").remove(this.metricsConfig);
        if (jmxPrometheusExporterMetricsConfig!=null){ this.metricsConfig= new JmxPrometheusExporterMetricsBuilder(jmxPrometheusExporterMetricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);} return (A) this;
    }

    public CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig() {
        return new JmxPrometheusExporterMetricsConfigNestedImpl();
    }

    public CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item) {
        return new JmxPrometheusExporterMetricsConfigNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CruiseControlSpecFluentImpl that = (CruiseControlSpecFluentImpl) o;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (tlsSidecar != null ? !tlsSidecar.equals(that.tlsSidecar) :that.tlsSidecar != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
        if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
        if (jvmOptions != null ? !jvmOptions.equals(that.jvmOptions) :that.jvmOptions != null) return false;
        if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        if (brokerCapacity != null ? !brokerCapacity.equals(that.brokerCapacity) :that.brokerCapacity != null) return false;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
        if (metricsConfig != null ? !metricsConfig.equals(that.metricsConfig) :that.metricsConfig != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(image,  tlsSidecar,  resources,  livenessProbe,  readinessProbe,  jvmOptions,  logging,  template,  brokerCapacity,  config,  metrics,  metricsConfig,  super.hashCode());
    }

    public class TlsSidecarNestedImpl<N> extends TlsSidecarFluentImpl<CruiseControlSpecFluent.TlsSidecarNested<N>> implements CruiseControlSpecFluent.TlsSidecarNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TlsSidecarBuilder builder;

            TlsSidecarNestedImpl(TlsSidecar item) {
                this.builder = new TlsSidecarBuilder(this, item);
                        
            }

            TlsSidecarNestedImpl() {
                this.builder = new TlsSidecarBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withTlsSidecar(builder.build());
            }

            public N endTlsSidecar() {
                return and();
            }
    }


    public class LivenessProbeNestedImpl<N> extends ProbeFluentImpl<CruiseControlSpecFluent.LivenessProbeNested<N>> implements CruiseControlSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProbeBuilder builder;

            LivenessProbeNestedImpl(Probe item) {
                this.builder = new ProbeBuilder(this, item);
                        
            }

            LivenessProbeNestedImpl() {
                this.builder = new ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withLivenessProbe(builder.build());
            }

            public N endLivenessProbe() {
                return and();
            }
    }


    public class ReadinessProbeNestedImpl<N> extends ProbeFluentImpl<CruiseControlSpecFluent.ReadinessProbeNested<N>> implements CruiseControlSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ProbeBuilder builder;

            ReadinessProbeNestedImpl(Probe item) {
                this.builder = new ProbeBuilder(this, item);
                        
            }

            ReadinessProbeNestedImpl() {
                this.builder = new ProbeBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withReadinessProbe(builder.build());
            }

            public N endReadinessProbe() {
                return and();
            }
    }


    public class JvmOptionsNestedImpl<N> extends JvmOptionsFluentImpl<CruiseControlSpecFluent.JvmOptionsNested<N>> implements CruiseControlSpecFluent.JvmOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final JvmOptionsBuilder builder;

            JvmOptionsNestedImpl(JvmOptions item) {
                this.builder = new JvmOptionsBuilder(this, item);
                        
            }

            JvmOptionsNestedImpl() {
                this.builder = new JvmOptionsBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withJvmOptions(builder.build());
            }

            public N endJvmOptions() {
                return and();
            }
    }


    public class ExternalLoggingNestedImpl<N> extends ExternalLoggingFluentImpl<CruiseControlSpecFluent.ExternalLoggingNested<N>> implements CruiseControlSpecFluent.ExternalLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExternalLoggingBuilder builder;

            ExternalLoggingNestedImpl(ExternalLogging item) {
                this.builder = new ExternalLoggingBuilder(this, item);
                        
            }

            ExternalLoggingNestedImpl() {
                this.builder = new ExternalLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endExternalLogging() {
                return and();
            }
    }


    public class InlineLoggingNestedImpl<N> extends InlineLoggingFluentImpl<CruiseControlSpecFluent.InlineLoggingNested<N>> implements CruiseControlSpecFluent.InlineLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final InlineLoggingBuilder builder;

            InlineLoggingNestedImpl(InlineLogging item) {
                this.builder = new InlineLoggingBuilder(this, item);
                        
            }

            InlineLoggingNestedImpl() {
                this.builder = new InlineLoggingBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withLogging(builder.build());
            }

            public N endInlineLogging() {
                return and();
            }
    }


    public class TemplateNestedImpl<N> extends CruiseControlTemplateFluentImpl<CruiseControlSpecFluent.TemplateNested<N>> implements CruiseControlSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CruiseControlTemplateBuilder builder;

            TemplateNestedImpl(CruiseControlTemplate item) {
                this.builder = new CruiseControlTemplateBuilder(this, item);
                        
            }

            TemplateNestedImpl() {
                this.builder = new CruiseControlTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withTemplate(builder.build());
            }

            public N endTemplate() {
                return and();
            }
    }


    public class BrokerCapacityNestedImpl<N> extends BrokerCapacityFluentImpl<CruiseControlSpecFluent.BrokerCapacityNested<N>> implements CruiseControlSpecFluent.BrokerCapacityNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BrokerCapacityBuilder builder;

            BrokerCapacityNestedImpl(BrokerCapacity item) {
                this.builder = new BrokerCapacityBuilder(this, item);
                        
            }

            BrokerCapacityNestedImpl() {
                this.builder = new BrokerCapacityBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withBrokerCapacity(builder.build());
            }

            public N endBrokerCapacity() {
                return and();
            }
    }


    public class JmxPrometheusExporterMetricsConfigNestedImpl<N> extends JmxPrometheusExporterMetricsFluentImpl<CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>> implements CruiseControlSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final JmxPrometheusExporterMetricsBuilder builder;

            JmxPrometheusExporterMetricsConfigNestedImpl(JmxPrometheusExporterMetrics item) {
                this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
                        
            }

            JmxPrometheusExporterMetricsConfigNestedImpl() {
                this.builder = new JmxPrometheusExporterMetricsBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlSpecFluentImpl.this.withMetricsConfig(builder.build());
            }

            public N endJmxPrometheusExporterMetricsConfig() {
                return and();
            }
    }


}
