package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalConfigurationReferenceBuilder extends ExternalConfigurationReferenceFluentImpl<ExternalConfigurationReferenceBuilder> implements VisitableBuilder<ExternalConfigurationReference,ExternalConfigurationReferenceBuilder> {

    ExternalConfigurationReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalConfigurationReferenceBuilder() {
        this(true);
    }

    public ExternalConfigurationReferenceBuilder(Boolean validationEnabled) {
        this(new ExternalConfigurationReference(), validationEnabled);
    }

    public ExternalConfigurationReferenceBuilder(ExternalConfigurationReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public ExternalConfigurationReferenceBuilder(ExternalConfigurationReferenceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ExternalConfigurationReference(), validationEnabled);
    }

    public ExternalConfigurationReferenceBuilder(ExternalConfigurationReferenceFluent<?> fluent,ExternalConfigurationReference instance) {
        this(fluent, instance, true);
    }

    public ExternalConfigurationReferenceBuilder(ExternalConfigurationReferenceFluent<?> fluent,ExternalConfigurationReference instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        
        this.validationEnabled = validationEnabled; 
    }

    public ExternalConfigurationReferenceBuilder(ExternalConfigurationReference instance) {
        this(instance,true);
    }

    public ExternalConfigurationReferenceBuilder(ExternalConfigurationReference instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConfigMapKeyRef(instance.getConfigMapKeyRef());
        
        this.validationEnabled = validationEnabled; 
    }

    public ExternalConfigurationReference build() {
        ExternalConfigurationReference buildable = new ExternalConfigurationReference();
        buildable.setConfigMapKeyRef(fluent.getConfigMapKeyRef());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExternalConfigurationReferenceBuilder that = (ExternalConfigurationReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
