package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalLoggingBuilder extends ExternalLoggingFluentImpl<ExternalLoggingBuilder> implements VisitableBuilder<ExternalLogging,ExternalLoggingBuilder> {

    ExternalLoggingFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalLoggingBuilder() {
        this(true);
    }

    public ExternalLoggingBuilder(Boolean validationEnabled) {
        this(new ExternalLogging(), validationEnabled);
    }

    public ExternalLoggingBuilder(ExternalLoggingFluent<?> fluent) {
        this(fluent, true);
    }

    public ExternalLoggingBuilder(ExternalLoggingFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ExternalLogging(), validationEnabled);
    }

    public ExternalLoggingBuilder(ExternalLoggingFluent<?> fluent,ExternalLogging instance) {
        this(fluent, instance, true);
    }

    public ExternalLoggingBuilder(ExternalLoggingFluent<?> fluent,ExternalLogging instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName());
        
        fluent.withValueFrom(instance.getValueFrom());
        
        this.validationEnabled = validationEnabled; 
    }

    public ExternalLoggingBuilder(ExternalLogging instance) {
        this(instance,true);
    }

    public ExternalLoggingBuilder(ExternalLogging instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName());
        
        this.withValueFrom(instance.getValueFrom());
        
        this.validationEnabled = validationEnabled; 
    }

    public ExternalLogging build() {
        ExternalLogging buildable = new ExternalLogging();
        buildable.setName(fluent.getName());
        buildable.setValueFrom(fluent.getValueFrom());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExternalLoggingBuilder that = (ExternalLoggingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
