package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface InlineLoggingFluent<A extends InlineLoggingFluent<A>> extends Fluent<A> {


    public A addToLoggers(String key,String value);
    public A addToLoggers(Map<String,String> map);
    public A removeFromLoggers(String key);
    public A removeFromLoggers(Map<String,String> map);
    public Map<String,String> getLoggers();
    public <K extends Object,V extends Object>A withLoggers(Map<String,String> loggers);
    public Boolean hasLoggers();
}
