package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaAuthorizationCustomBuilder extends KafkaAuthorizationCustomFluentImpl<KafkaAuthorizationCustomBuilder> implements VisitableBuilder<KafkaAuthorizationCustom,KafkaAuthorizationCustomBuilder> {

    KafkaAuthorizationCustomFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaAuthorizationCustomBuilder() {
        this(true);
    }

    public KafkaAuthorizationCustomBuilder(Boolean validationEnabled) {
        this(new KafkaAuthorizationCustom(), validationEnabled);
    }

    public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaAuthorizationCustom(), validationEnabled);
    }

    public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent,KafkaAuthorizationCustom instance) {
        this(fluent, instance, true);
    }

    public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustomFluent<?> fluent,KafkaAuthorizationCustom instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAuthorizerClass(instance.getAuthorizerClass());
        
        fluent.withSuperUsers(instance.getSuperUsers());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustom instance) {
        this(instance,true);
    }

    public KafkaAuthorizationCustomBuilder(KafkaAuthorizationCustom instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAuthorizerClass(instance.getAuthorizerClass());
        
        this.withSuperUsers(instance.getSuperUsers());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaAuthorizationCustom build() {
        KafkaAuthorizationCustom buildable = new KafkaAuthorizationCustom();
        buildable.setAuthorizerClass(fluent.getAuthorizerClass());
        buildable.setSuperUsers(fluent.getSuperUsers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaAuthorizationCustomBuilder that = (KafkaAuthorizationCustomBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
