package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaAuthorizationOpaBuilder extends KafkaAuthorizationOpaFluentImpl<KafkaAuthorizationOpaBuilder> implements VisitableBuilder<KafkaAuthorizationOpa,KafkaAuthorizationOpaBuilder> {

    KafkaAuthorizationOpaFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaAuthorizationOpaBuilder() {
        this(true);
    }

    public KafkaAuthorizationOpaBuilder(Boolean validationEnabled) {
        this(new KafkaAuthorizationOpa(), validationEnabled);
    }

    public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpaFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpaFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaAuthorizationOpa(), validationEnabled);
    }

    public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpaFluent<?> fluent,KafkaAuthorizationOpa instance) {
        this(fluent, instance, true);
    }

    public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpaFluent<?> fluent,KafkaAuthorizationOpa instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSuperUsers(instance.getSuperUsers());
        
        fluent.withUrl(instance.getUrl());
        
        fluent.withAllowOnError(instance.isAllowOnError());
        
        fluent.withInitialCacheCapacity(instance.getInitialCacheCapacity());
        
        fluent.withMaximumCacheSize(instance.getMaximumCacheSize());
        
        fluent.withExpireAfterMs(instance.getExpireAfterMs());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpa instance) {
        this(instance,true);
    }

    public KafkaAuthorizationOpaBuilder(KafkaAuthorizationOpa instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withSuperUsers(instance.getSuperUsers());
        
        this.withUrl(instance.getUrl());
        
        this.withAllowOnError(instance.isAllowOnError());
        
        this.withInitialCacheCapacity(instance.getInitialCacheCapacity());
        
        this.withMaximumCacheSize(instance.getMaximumCacheSize());
        
        this.withExpireAfterMs(instance.getExpireAfterMs());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaAuthorizationOpa build() {
        KafkaAuthorizationOpa buildable = new KafkaAuthorizationOpa();
        buildable.setSuperUsers(fluent.getSuperUsers());
        buildable.setUrl(fluent.getUrl());
        buildable.setAllowOnError(fluent.isAllowOnError());
        buildable.setInitialCacheCapacity(fluent.getInitialCacheCapacity());
        buildable.setMaximumCacheSize(fluent.getMaximumCacheSize());
        buildable.setExpireAfterMs(fluent.getExpireAfterMs());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaAuthorizationOpaBuilder that = (KafkaAuthorizationOpaBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
