package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBridgeBuilder extends KafkaBridgeFluentImpl<KafkaBridgeBuilder> implements VisitableBuilder<KafkaBridge,KafkaBridgeBuilder> {

    KafkaBridgeFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBridgeBuilder() {
        this(true);
    }

    public KafkaBridgeBuilder(Boolean validationEnabled) {
        this(new KafkaBridge(), validationEnabled);
    }

    public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaBridge(), validationEnabled);
    }

    public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent,KafkaBridge instance) {
        this(fluent, instance, true);
    }

    public KafkaBridgeBuilder(KafkaBridgeFluent<?> fluent,KafkaBridge instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeBuilder(KafkaBridge instance) {
        this(instance,true);
    }

    public KafkaBridgeBuilder(KafkaBridge instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridge build() {
        KafkaBridge buildable = new KafkaBridge();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBridgeBuilder that = (KafkaBridgeBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
