package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.strimzi.api.kafka.model.status.KafkaBridgeStatusFluent;
import io.strimzi.api.kafka.model.status.KafkaBridgeStatus;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.strimzi.api.kafka.model.status.KafkaBridgeStatusBuilder;
import java.lang.Deprecated;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KafkaBridgeFluent<A extends KafkaBridgeFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public KafkaBridgeFluent.MetadataNested<A> withNewMetadata();
    public KafkaBridgeFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public KafkaBridgeFluent.MetadataNested<A> editMetadata();
    public KafkaBridgeFluent.MetadataNested<A> editOrNewMetadata();
    public KafkaBridgeFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeSpec getSpec();
    public KafkaBridgeSpec buildSpec();
    public A withSpec(KafkaBridgeSpec spec);
    public Boolean hasSpec();
    public KafkaBridgeFluent.SpecNested<A> withNewSpec();
    public KafkaBridgeFluent.SpecNested<A> withNewSpecLike(KafkaBridgeSpec item);
    public KafkaBridgeFluent.SpecNested<A> editSpec();
    public KafkaBridgeFluent.SpecNested<A> editOrNewSpec();
    public KafkaBridgeFluent.SpecNested<A> editOrNewSpecLike(KafkaBridgeSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaBridgeStatus getStatus();
    public KafkaBridgeStatus buildStatus();
    public A withStatus(KafkaBridgeStatus status);
    public Boolean hasStatus();
    public KafkaBridgeFluent.StatusNested<A> withNewStatus();
    public KafkaBridgeFluent.StatusNested<A> withNewStatusLike(KafkaBridgeStatus item);
    public KafkaBridgeFluent.StatusNested<A> editStatus();
    public KafkaBridgeFluent.StatusNested<A> editOrNewStatus();
    public KafkaBridgeFluent.StatusNested<A> editOrNewStatusLike(KafkaBridgeStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<KafkaBridgeFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaBridgeSpecFluent<KafkaBridgeFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaBridgeStatusFluent<KafkaBridgeFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
