package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaBridgeHttpCorsBuilder extends KafkaBridgeHttpCorsFluentImpl<KafkaBridgeHttpCorsBuilder> implements VisitableBuilder<KafkaBridgeHttpCors,KafkaBridgeHttpCorsBuilder> {

    KafkaBridgeHttpCorsFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaBridgeHttpCorsBuilder() {
        this(true);
    }

    public KafkaBridgeHttpCorsBuilder(Boolean validationEnabled) {
        this(new KafkaBridgeHttpCors(), validationEnabled);
    }

    public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCorsFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCorsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaBridgeHttpCors(), validationEnabled);
    }

    public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCorsFluent<?> fluent,KafkaBridgeHttpCors instance) {
        this(fluent, instance, true);
    }

    public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCorsFluent<?> fluent,KafkaBridgeHttpCors instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAllowedOrigins(instance.getAllowedOrigins());
        
        fluent.withAllowedMethods(instance.getAllowedMethods());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCors instance) {
        this(instance,true);
    }

    public KafkaBridgeHttpCorsBuilder(KafkaBridgeHttpCors instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAllowedOrigins(instance.getAllowedOrigins());
        
        this.withAllowedMethods(instance.getAllowedMethods());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeHttpCors build() {
        KafkaBridgeHttpCors buildable = new KafkaBridgeHttpCors();
        buildable.setAllowedOrigins(fluent.getAllowedOrigins());
        buildable.setAllowedMethods(fluent.getAllowedMethods());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBridgeHttpCorsBuilder that = (KafkaBridgeHttpCorsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
