package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.status.KafkaConnectStatusBuilder;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.status.KafkaConnectStatus;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.strimzi.api.kafka.model.status.KafkaConnectStatusFluentImpl;
import java.lang.StringBuffer;
import java.lang.Object;

public class KafkaConnectFluentImpl<A extends KafkaConnectFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaConnectFluent<A> {

    private String apiVersion;
    private KafkaConnectSpecBuilder spec;
    private ObjectMetaBuilder metadata;
    private KafkaConnectStatusBuilder status;

    public KafkaConnectFluentImpl() {
    }

    public KafkaConnectFluentImpl(KafkaConnect instance) {
        this.withApiVersion(instance.getApiVersion());
        
        this.withSpec(instance.getSpec());
        
        this.withMetadata(instance.getMetadata());
        
        this.withStatus(instance.getStatus());
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaConnectSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public KafkaConnectSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(KafkaConnectSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new KafkaConnectSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public KafkaConnectFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public KafkaConnectFluent.SpecNested<A> withNewSpecLike(KafkaConnectSpec item) {
        return new SpecNestedImpl(item);
    }

    public KafkaConnectFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public KafkaConnectFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new KafkaConnectSpecBuilder().build());
    }

    public KafkaConnectFluent.SpecNested<A> editOrNewSpecLike(KafkaConnectSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public KafkaConnectFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public KafkaConnectFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public KafkaConnectFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public KafkaConnectFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public KafkaConnectFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaConnectStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public KafkaConnectStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(KafkaConnectStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new KafkaConnectStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public KafkaConnectFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public KafkaConnectFluent.StatusNested<A> withNewStatusLike(KafkaConnectStatus item) {
        return new StatusNestedImpl(item);
    }

    public KafkaConnectFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public KafkaConnectFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new KafkaConnectStatusBuilder().build());
    }

    public KafkaConnectFluent.StatusNested<A> editOrNewStatusLike(KafkaConnectStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaConnectFluentImpl that = (KafkaConnectFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  spec,  metadata,  status,  super.hashCode());
    }

    public class SpecNestedImpl<N> extends KafkaConnectSpecFluentImpl<KafkaConnectFluent.SpecNested<N>> implements KafkaConnectFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaConnectSpecBuilder builder;

            SpecNestedImpl(KafkaConnectSpec item) {
                this.builder = new KafkaConnectSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new KafkaConnectSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<KafkaConnectFluent.MetadataNested<N>> implements KafkaConnectFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class StatusNestedImpl<N> extends KafkaConnectStatusFluentImpl<KafkaConnectFluent.StatusNested<N>> implements KafkaConnectFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaConnectStatusBuilder builder;

            StatusNestedImpl(KafkaConnectStatus item) {
                this.builder = new KafkaConnectStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new KafkaConnectStatusBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
