package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512FluentImpl;
import java.lang.String;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.connect.build.Build;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.strimzi.api.kafka.model.connect.build.BuildFluentImpl;
import io.strimzi.api.kafka.model.connect.build.BuildBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluentImpl;
import java.lang.StringBuffer;

public class KafkaConnectSpecFluentImpl<A extends KafkaConnectSpecFluent<A>> extends AbstractKafkaConnectSpecFluentImpl<A> implements KafkaConnectSpecFluent<A> {

    private Map<String,Object> config;
    private String clientRackInitImage;
    private RackBuilder rack;
    private String bootstrapServers;
    private KafkaConnectTlsBuilder tls;
    private VisitableBuilder<? extends KafkaClientAuthentication,?> authentication;
    private BuildBuilder build;

    public KafkaConnectSpecFluentImpl() {
    }

    public KafkaConnectSpecFluentImpl(KafkaConnectSpec instance) {
        this.withConfig(instance.getConfig());
        
        this.withClientRackInitImage(instance.getClientRackInitImage());
        
        this.withRack(instance.getRack());
        
        this.withBootstrapServers(instance.getBootstrapServers());
        
        this.withTls(instance.getTls());
        
        this.withAuthentication(instance.getAuthentication());
        
        this.withBuild(instance.getBuild());
        
        this.withLogging(instance.getLogging());
        
        this.withReplicas(instance.getReplicas());
        
        this.withVersion(instance.getVersion());
        
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.withLivenessProbe(instance.getLivenessProbe());
        
        this.withReadinessProbe(instance.getReadinessProbe());
        
        this.withJmxOptions(instance.getJmxOptions());
        
        this.withJvmOptions(instance.getJvmOptions());
        
        this.withMetricsConfig(instance.getMetricsConfig());
        
        this.withMetrics(instance.getMetrics());
        
        this.withTracing(instance.getTracing());
        
        this.withAffinity(instance.getAffinity());
        
        this.withTolerations(instance.getTolerations());
        
        this.withTemplate(instance.getTemplate());
        
        this.withExternalConfiguration(instance.getExternalConfiguration());
    }

    public A addToConfig(String key,Object value) {
        if(this.config == null && key != null && value != null) { this.config = new LinkedHashMap<String,Object>(); }
        if(key != null && value != null) {this.config.put(key, value);} return (A)this;
    }

    public A addToConfig(Map<String,Object> map) {
        if(this.config == null && map != null) { this.config = new LinkedHashMap<String,Object>(); }
        if(map != null) { this.config.putAll(map);} return (A)this;
    }

    public A removeFromConfig(String key) {
        if(this.config == null) { return (A) this; }
        if(key != null && this.config != null) {this.config.remove(key);} return (A)this;
    }

    public A removeFromConfig(Map<String,Object> map) {
        if(this.config == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.config != null){this.config.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getConfig() {
        return this.config;
    }

    public <K extends Object,V extends Object>A withConfig(Map<String,Object> config) {
        if (config == null) { this.config =  null;} else {this.config = new LinkedHashMap<String,Object>(config);} return (A) this;
    }

    public Boolean hasConfig() {
        return this.config != null;
    }

    public String getClientRackInitImage() {
        return this.clientRackInitImage;
    }

    public A withClientRackInitImage(String clientRackInitImage) {
        this.clientRackInitImage=clientRackInitImage; return (A) this;
    }

    public Boolean hasClientRackInitImage() {
        return this.clientRackInitImage != null;
    }

    public A withNewClientRackInitImage(StringBuilder arg1) {
        return (A)withClientRackInitImage(new String(arg1));
    }

    public A withNewClientRackInitImage(int[] arg1,int arg2,int arg3) {
        return (A)withClientRackInitImage(new String(arg1, arg2, arg3));
    }

    public A withNewClientRackInitImage(char[] arg1) {
        return (A)withClientRackInitImage(new String(arg1));
    }

    public A withNewClientRackInitImage(StringBuffer arg1) {
        return (A)withClientRackInitImage(new String(arg1));
    }

    public A withNewClientRackInitImage(byte[] arg1,int arg2) {
        return (A)withClientRackInitImage(new String(arg1, arg2));
    }

    public A withNewClientRackInitImage(byte[] arg1) {
        return (A)withClientRackInitImage(new String(arg1));
    }

    public A withNewClientRackInitImage(char[] arg1,int arg2,int arg3) {
        return (A)withClientRackInitImage(new String(arg1, arg2, arg3));
    }

    public A withNewClientRackInitImage(byte[] arg1,int arg2,int arg3) {
        return (A)withClientRackInitImage(new String(arg1, arg2, arg3));
    }

    public A withNewClientRackInitImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withClientRackInitImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewClientRackInitImage(String arg1) {
        return (A)withClientRackInitImage(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildRack instead.
 * @return The buildable object.
 */
@Deprecated public Rack getRack() {
        return this.rack!=null?this.rack.build():null;
    }

    public Rack buildRack() {
        return this.rack!=null?this.rack.build():null;
    }

    public A withRack(Rack rack) {
        _visitables.get("rack").remove(this.rack);
        if (rack!=null){ this.rack= new RackBuilder(rack); _visitables.get("rack").add(this.rack);} return (A) this;
    }

    public Boolean hasRack() {
        return this.rack != null;
    }

    public A withNewRack(String topologyKey) {
        return (A)withRack(new Rack(topologyKey));
    }

    public KafkaConnectSpecFluent.RackNested<A> withNewRack() {
        return new RackNestedImpl();
    }

    public KafkaConnectSpecFluent.RackNested<A> withNewRackLike(Rack item) {
        return new RackNestedImpl(item);
    }

    public KafkaConnectSpecFluent.RackNested<A> editRack() {
        return withNewRackLike(getRack());
    }

    public KafkaConnectSpecFluent.RackNested<A> editOrNewRack() {
        return withNewRackLike(getRack() != null ? getRack(): new RackBuilder().build());
    }

    public KafkaConnectSpecFluent.RackNested<A> editOrNewRackLike(Rack item) {
        return withNewRackLike(getRack() != null ? getRack(): item);
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public A withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers=bootstrapServers; return (A) this;
    }

    public Boolean hasBootstrapServers() {
        return this.bootstrapServers != null;
    }

    public A withNewBootstrapServers(StringBuilder arg1) {
        return (A)withBootstrapServers(new String(arg1));
    }

    public A withNewBootstrapServers(int[] arg1,int arg2,int arg3) {
        return (A)withBootstrapServers(new String(arg1, arg2, arg3));
    }

    public A withNewBootstrapServers(char[] arg1) {
        return (A)withBootstrapServers(new String(arg1));
    }

    public A withNewBootstrapServers(StringBuffer arg1) {
        return (A)withBootstrapServers(new String(arg1));
    }

    public A withNewBootstrapServers(byte[] arg1,int arg2) {
        return (A)withBootstrapServers(new String(arg1, arg2));
    }

    public A withNewBootstrapServers(byte[] arg1) {
        return (A)withBootstrapServers(new String(arg1));
    }

    public A withNewBootstrapServers(char[] arg1,int arg2,int arg3) {
        return (A)withBootstrapServers(new String(arg1, arg2, arg3));
    }

    public A withNewBootstrapServers(byte[] arg1,int arg2,int arg3) {
        return (A)withBootstrapServers(new String(arg1, arg2, arg3));
    }

    public A withNewBootstrapServers(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBootstrapServers(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBootstrapServers(String arg1) {
        return (A)withBootstrapServers(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public KafkaConnectTls getTls() {
        return this.tls!=null?this.tls.build():null;
    }

    public KafkaConnectTls buildTls() {
        return this.tls!=null?this.tls.build():null;
    }

    public A withTls(KafkaConnectTls tls) {
        _visitables.get("tls").remove(this.tls);
        if (tls!=null){ this.tls= new KafkaConnectTlsBuilder(tls); _visitables.get("tls").add(this.tls);} return (A) this;
    }

    public Boolean hasTls() {
        return this.tls != null;
    }

    public KafkaConnectSpecFluent.TlsNested<A> withNewTls() {
        return new TlsNestedImpl();
    }

    public KafkaConnectSpecFluent.TlsNested<A> withNewTlsLike(KafkaConnectTls item) {
        return new TlsNestedImpl(item);
    }

    public KafkaConnectSpecFluent.TlsNested<A> editTls() {
        return withNewTlsLike(getTls());
    }

    public KafkaConnectSpecFluent.TlsNested<A> editOrNewTls() {
        return withNewTlsLike(getTls() != null ? getTls(): new KafkaConnectTlsBuilder().build());
    }

    public KafkaConnectSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaConnectTls item) {
        return withNewTlsLike(getTls() != null ? getTls(): item);
    }

    
/**
 * This method has been deprecated, please use method buildAuthentication instead.
 * @return The buildable object.
 */
@Deprecated public KafkaClientAuthentication getAuthentication() {
        return this.authentication!=null?this.authentication.build():null;
    }

    public KafkaClientAuthentication buildAuthentication() {
        return this.authentication!=null?this.authentication.build():null;
    }

    public A withAuthentication(KafkaClientAuthentication authentication) {
        if (authentication instanceof KafkaClientAuthenticationScramSha512){ this.authentication= new KafkaClientAuthenticationScramSha512Builder((KafkaClientAuthenticationScramSha512)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof KafkaClientAuthenticationPlain){ this.authentication= new KafkaClientAuthenticationPlainBuilder((KafkaClientAuthenticationPlain)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof KafkaClientAuthenticationOAuth){ this.authentication= new KafkaClientAuthenticationOAuthBuilder((KafkaClientAuthenticationOAuth)authentication); _visitables.get("authentication").add(this.authentication);}
        if (authentication instanceof KafkaClientAuthenticationTls){ this.authentication= new KafkaClientAuthenticationTlsBuilder((KafkaClientAuthenticationTls)authentication); _visitables.get("authentication").add(this.authentication);}
        return (A) this;
    }

    public Boolean hasAuthentication() {
        return this.authentication != null;
    }

    public A withKafkaClientAuthenticationScramSha512(KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationScramSha512!=null){ this.authentication= new KafkaClientAuthenticationScramSha512Builder(kafkaClientAuthenticationScramSha512); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512() {
        return new KafkaClientAuthenticationScramSha512NestedImpl();
    }

    public KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item) {
        return new KafkaClientAuthenticationScramSha512NestedImpl(item);
    }

    public A withKafkaClientAuthenticationPlain(KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationPlain!=null){ this.authentication= new KafkaClientAuthenticationPlainBuilder(kafkaClientAuthenticationPlain); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain() {
        return new KafkaClientAuthenticationPlainNestedImpl();
    }

    public KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item) {
        return new KafkaClientAuthenticationPlainNestedImpl(item);
    }

    public A withKafkaClientAuthenticationOAuth(KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationOAuth!=null){ this.authentication= new KafkaClientAuthenticationOAuthBuilder(kafkaClientAuthenticationOAuth); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth() {
        return new KafkaClientAuthenticationOAuthNestedImpl();
    }

    public KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item) {
        return new KafkaClientAuthenticationOAuthNestedImpl(item);
    }

    public A withKafkaClientAuthenticationTls(KafkaClientAuthenticationTls kafkaClientAuthenticationTls) {
        _visitables.get("authentication").remove(this.authentication);
        if (kafkaClientAuthenticationTls!=null){ this.authentication= new KafkaClientAuthenticationTlsBuilder(kafkaClientAuthenticationTls); _visitables.get("authentication").add(this.authentication);} return (A) this;
    }

    public KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls() {
        return new KafkaClientAuthenticationTlsNestedImpl();
    }

    public KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item) {
        return new KafkaClientAuthenticationTlsNestedImpl(item);
    }

    
/**
 * This method has been deprecated, please use method buildBuild instead.
 * @return The buildable object.
 */
@Deprecated public Build getBuild() {
        return this.build!=null?this.build.build():null;
    }

    public Build buildBuild() {
        return this.build!=null?this.build.build():null;
    }

    public A withBuild(Build build) {
        _visitables.get("build").remove(this.build);
        if (build!=null){ this.build= new BuildBuilder(build); _visitables.get("build").add(this.build);} return (A) this;
    }

    public Boolean hasBuild() {
        return this.build != null;
    }

    public KafkaConnectSpecFluent.BuildNested<A> withNewBuild() {
        return new BuildNestedImpl();
    }

    public KafkaConnectSpecFluent.BuildNested<A> withNewBuildLike(Build item) {
        return new BuildNestedImpl(item);
    }

    public KafkaConnectSpecFluent.BuildNested<A> editBuild() {
        return withNewBuildLike(getBuild());
    }

    public KafkaConnectSpecFluent.BuildNested<A> editOrNewBuild() {
        return withNewBuildLike(getBuild() != null ? getBuild(): new BuildBuilder().build());
    }

    public KafkaConnectSpecFluent.BuildNested<A> editOrNewBuildLike(Build item) {
        return withNewBuildLike(getBuild() != null ? getBuild(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectSpecFluentImpl that = (KafkaConnectSpecFluentImpl) o;
        if (config != null ? !config.equals(that.config) :that.config != null) return false;
        if (clientRackInitImage != null ? !clientRackInitImage.equals(that.clientRackInitImage) :that.clientRackInitImage != null) return false;
        if (rack != null ? !rack.equals(that.rack) :that.rack != null) return false;
        if (bootstrapServers != null ? !bootstrapServers.equals(that.bootstrapServers) :that.bootstrapServers != null) return false;
        if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
        if (authentication != null ? !authentication.equals(that.authentication) :that.authentication != null) return false;
        if (build != null ? !build.equals(that.build) :that.build != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(config,  clientRackInitImage,  rack,  bootstrapServers,  tls,  authentication,  build,  super.hashCode());
    }

    public class RackNestedImpl<N> extends RackFluentImpl<KafkaConnectSpecFluent.RackNested<N>> implements KafkaConnectSpecFluent.RackNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RackBuilder builder;

            RackNestedImpl(Rack item) {
                this.builder = new RackBuilder(this, item);
                        
            }

            RackNestedImpl() {
                this.builder = new RackBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectSpecFluentImpl.this.withRack(builder.build());
            }

            public N endRack() {
                return and();
            }
    }


    public class TlsNestedImpl<N> extends KafkaConnectTlsFluentImpl<KafkaConnectSpecFluent.TlsNested<N>> implements KafkaConnectSpecFluent.TlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaConnectTlsBuilder builder;

            TlsNestedImpl(KafkaConnectTls item) {
                this.builder = new KafkaConnectTlsBuilder(this, item);
                        
            }

            TlsNestedImpl() {
                this.builder = new KafkaConnectTlsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectSpecFluentImpl.this.withTls(builder.build());
            }

            public N endTls() {
                return and();
            }
    }


    public class KafkaClientAuthenticationScramSha512NestedImpl<N> extends KafkaClientAuthenticationScramSha512FluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>> implements KafkaConnectSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaClientAuthenticationScramSha512Builder builder;

            KafkaClientAuthenticationScramSha512NestedImpl(KafkaClientAuthenticationScramSha512 item) {
                this.builder = new KafkaClientAuthenticationScramSha512Builder(this, item);
                        
            }

            KafkaClientAuthenticationScramSha512NestedImpl() {
                this.builder = new KafkaClientAuthenticationScramSha512Builder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationScramSha512() {
                return and();
            }
    }


    public class KafkaClientAuthenticationPlainNestedImpl<N> extends KafkaClientAuthenticationPlainFluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<N>> implements KafkaConnectSpecFluent.KafkaClientAuthenticationPlainNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaClientAuthenticationPlainBuilder builder;

            KafkaClientAuthenticationPlainNestedImpl(KafkaClientAuthenticationPlain item) {
                this.builder = new KafkaClientAuthenticationPlainBuilder(this, item);
                        
            }

            KafkaClientAuthenticationPlainNestedImpl() {
                this.builder = new KafkaClientAuthenticationPlainBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationPlain() {
                return and();
            }
    }


    public class KafkaClientAuthenticationOAuthNestedImpl<N> extends KafkaClientAuthenticationOAuthFluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<N>> implements KafkaConnectSpecFluent.KafkaClientAuthenticationOAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaClientAuthenticationOAuthBuilder builder;

            KafkaClientAuthenticationOAuthNestedImpl(KafkaClientAuthenticationOAuth item) {
                this.builder = new KafkaClientAuthenticationOAuthBuilder(this, item);
                        
            }

            KafkaClientAuthenticationOAuthNestedImpl() {
                this.builder = new KafkaClientAuthenticationOAuthBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationOAuth() {
                return and();
            }
    }


    public class KafkaClientAuthenticationTlsNestedImpl<N> extends KafkaClientAuthenticationTlsFluentImpl<KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<N>> implements KafkaConnectSpecFluent.KafkaClientAuthenticationTlsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaClientAuthenticationTlsBuilder builder;

            KafkaClientAuthenticationTlsNestedImpl(KafkaClientAuthenticationTls item) {
                this.builder = new KafkaClientAuthenticationTlsBuilder(this, item);
                        
            }

            KafkaClientAuthenticationTlsNestedImpl() {
                this.builder = new KafkaClientAuthenticationTlsBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectSpecFluentImpl.this.withAuthentication(builder.build());
            }

            public N endKafkaClientAuthenticationTls() {
                return and();
            }
    }


    public class BuildNestedImpl<N> extends BuildFluentImpl<KafkaConnectSpecFluent.BuildNested<N>> implements KafkaConnectSpecFluent.BuildNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final BuildBuilder builder;

            BuildNestedImpl(Build item) {
                this.builder = new BuildBuilder(this, item);
                        
            }

            BuildNestedImpl() {
                this.builder = new BuildBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectSpecFluentImpl.this.withBuild(builder.build());
            }

            public N endBuild() {
                return and();
            }
    }


}
