package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectTlsBuilder extends KafkaConnectTlsFluentImpl<KafkaConnectTlsBuilder> implements VisitableBuilder<KafkaConnectTls,KafkaConnectTlsBuilder> {

    KafkaConnectTlsFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectTlsBuilder() {
        this(true);
    }

    public KafkaConnectTlsBuilder(Boolean validationEnabled) {
        this(new KafkaConnectTls(), validationEnabled);
    }

    public KafkaConnectTlsBuilder(KafkaConnectTlsFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaConnectTlsBuilder(KafkaConnectTlsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaConnectTls(), validationEnabled);
    }

    public KafkaConnectTlsBuilder(KafkaConnectTlsFluent<?> fluent,KafkaConnectTls instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectTlsBuilder(KafkaConnectTlsFluent<?> fluent,KafkaConnectTls instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTrustedCertificates(instance.getTrustedCertificates());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectTlsBuilder(KafkaConnectTls instance) {
        this(instance,true);
    }

    public KafkaConnectTlsBuilder(KafkaConnectTls instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withTrustedCertificates(instance.getTrustedCertificates());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectTls build() {
        KafkaConnectTls buildable = new KafkaConnectTls();
        buildable.setTrustedCertificates(fluent.getTrustedCertificates());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectTlsBuilder that = (KafkaConnectTlsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
