package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaConnectorBuilder extends KafkaConnectorFluentImpl<KafkaConnectorBuilder> implements VisitableBuilder<KafkaConnector,KafkaConnectorBuilder> {

    KafkaConnectorFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaConnectorBuilder() {
        this(true);
    }

    public KafkaConnectorBuilder(Boolean validationEnabled) {
        this(new KafkaConnector(), validationEnabled);
    }

    public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaConnector(), validationEnabled);
    }

    public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent,KafkaConnector instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectorBuilder(KafkaConnectorFluent<?> fluent,KafkaConnector instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withApiVersion(instance.getApiVersion());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectorBuilder(KafkaConnector instance) {
        this(instance,true);
    }

    public KafkaConnectorBuilder(KafkaConnector instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.withMetadata(instance.getMetadata());
        
        this.withApiVersion(instance.getApiVersion());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnector build() {
        KafkaConnector buildable = new KafkaConnector();
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setApiVersion(fluent.getApiVersion());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectorBuilder that = (KafkaConnectorBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
