package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.template.KafkaExporterTemplate;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface KafkaExporterSpecFluent<A extends KafkaExporterSpecFluent<A>> extends Fluent<A> {


    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(int[] arg1,int arg2,int arg3);
    public A withNewImage(char[] arg1);
    public A withNewImage(StringBuffer arg1);
    public A withNewImage(byte[] arg1,int arg2);
    public A withNewImage(byte[] arg1);
    public A withNewImage(char[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3);
    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewImage(String arg1);
    public String getGroupRegex();
    public A withGroupRegex(String groupRegex);
    public Boolean hasGroupRegex();
    public A withNewGroupRegex(StringBuilder arg1);
    public A withNewGroupRegex(int[] arg1,int arg2,int arg3);
    public A withNewGroupRegex(char[] arg1);
    public A withNewGroupRegex(StringBuffer arg1);
    public A withNewGroupRegex(byte[] arg1,int arg2);
    public A withNewGroupRegex(byte[] arg1);
    public A withNewGroupRegex(char[] arg1,int arg2,int arg3);
    public A withNewGroupRegex(byte[] arg1,int arg2,int arg3);
    public A withNewGroupRegex(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewGroupRegex(String arg1);
    public String getTopicRegex();
    public A withTopicRegex(String topicRegex);
    public Boolean hasTopicRegex();
    public A withNewTopicRegex(StringBuilder arg1);
    public A withNewTopicRegex(int[] arg1,int arg2,int arg3);
    public A withNewTopicRegex(char[] arg1);
    public A withNewTopicRegex(StringBuffer arg1);
    public A withNewTopicRegex(byte[] arg1,int arg2);
    public A withNewTopicRegex(byte[] arg1);
    public A withNewTopicRegex(char[] arg1,int arg2,int arg3);
    public A withNewTopicRegex(byte[] arg1,int arg2,int arg3);
    public A withNewTopicRegex(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewTopicRegex(String arg1);
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe();
    public Probe buildLivenessProbe();
    public A withLivenessProbe(Probe livenessProbe);
    public Boolean hasLivenessProbe();
    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds);
    public KafkaExporterSpecFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public KafkaExporterSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item);
    public KafkaExporterSpecFluent.LivenessProbeNested<A> editLivenessProbe();
    public KafkaExporterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public KafkaExporterSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item);
    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe();
    public Probe buildReadinessProbe();
    public A withReadinessProbe(Probe readinessProbe);
    public Boolean hasReadinessProbe();
    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds);
    public KafkaExporterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public KafkaExporterSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item);
    public KafkaExporterSpecFluent.ReadinessProbeNested<A> editReadinessProbe();
    public KafkaExporterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public KafkaExporterSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item);
    public String getLogging();
    public A withLogging(String logging);
    public Boolean hasLogging();
    public A withNewLogging(StringBuilder arg1);
    public A withNewLogging(int[] arg1,int arg2,int arg3);
    public A withNewLogging(char[] arg1);
    public A withNewLogging(StringBuffer arg1);
    public A withNewLogging(byte[] arg1,int arg2);
    public A withNewLogging(byte[] arg1);
    public A withNewLogging(char[] arg1,int arg2,int arg3);
    public A withNewLogging(byte[] arg1,int arg2,int arg3);
    public A withNewLogging(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewLogging(String arg1);
    public boolean isEnableSaramaLogging();
    public A withEnableSaramaLogging(boolean enableSaramaLogging);
    public Boolean hasEnableSaramaLogging();
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public KafkaExporterTemplate getTemplate();
    public KafkaExporterTemplate buildTemplate();
    public A withTemplate(KafkaExporterTemplate template);
    public Boolean hasTemplate();
    public KafkaExporterSpecFluent.TemplateNested<A> withNewTemplate();
    public KafkaExporterSpecFluent.TemplateNested<A> withNewTemplateLike(KafkaExporterTemplate item);
    public KafkaExporterSpecFluent.TemplateNested<A> editTemplate();
    public KafkaExporterSpecFluent.TemplateNested<A> editOrNewTemplate();
    public KafkaExporterSpecFluent.TemplateNested<A> editOrNewTemplateLike(KafkaExporterTemplate item);
    public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<KafkaExporterSpecFluent.LivenessProbeNested<N>> {

            public N and();
            public N endLivenessProbe();    }


    public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<KafkaExporterSpecFluent.ReadinessProbeNested<N>> {

            public N and();
            public N endReadinessProbe();    }


    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaExporterTemplateFluent<KafkaExporterSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


}
