package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.status.KafkaStatusBuilder;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.util.List;
import io.strimzi.api.kafka.model.status.KafkaStatusFluent;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.status.KafkaStatus;
import java.util.Map;

public interface KafkaFluent<A extends KafkaFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public KafkaFluent.MetadataNested<A> withNewMetadata();
    public KafkaFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public KafkaFluent.MetadataNested<A> editMetadata();
    public KafkaFluent.MetadataNested<A> editOrNewMetadata();
    public KafkaFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaSpec getSpec();
    public KafkaSpec buildSpec();
    public A withSpec(KafkaSpec spec);
    public Boolean hasSpec();
    public KafkaFluent.SpecNested<A> withNewSpec();
    public KafkaFluent.SpecNested<A> withNewSpecLike(KafkaSpec item);
    public KafkaFluent.SpecNested<A> editSpec();
    public KafkaFluent.SpecNested<A> editOrNewSpec();
    public KafkaFluent.SpecNested<A> editOrNewSpecLike(KafkaSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaStatus getStatus();
    public KafkaStatus buildStatus();
    public A withStatus(KafkaStatus status);
    public Boolean hasStatus();
    public KafkaFluent.StatusNested<A> withNewStatus();
    public KafkaFluent.StatusNested<A> withNewStatusLike(KafkaStatus item);
    public KafkaFluent.StatusNested<A> editStatus();
    public KafkaFluent.StatusNested<A> editOrNewStatus();
    public KafkaFluent.StatusNested<A> editOrNewStatusLike(KafkaStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<KafkaFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaSpecFluent<KafkaFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaStatusFluent<KafkaFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
