package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaJmxAuthenticationPasswordBuilder extends KafkaJmxAuthenticationPasswordFluentImpl<KafkaJmxAuthenticationPasswordBuilder> implements VisitableBuilder<KafkaJmxAuthenticationPassword,KafkaJmxAuthenticationPasswordBuilder> {

    KafkaJmxAuthenticationPasswordFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaJmxAuthenticationPasswordBuilder() {
        this(true);
    }

    public KafkaJmxAuthenticationPasswordBuilder(Boolean validationEnabled) {
        this(new KafkaJmxAuthenticationPassword(), validationEnabled);
    }

    public KafkaJmxAuthenticationPasswordBuilder(KafkaJmxAuthenticationPasswordFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaJmxAuthenticationPasswordBuilder(KafkaJmxAuthenticationPasswordFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaJmxAuthenticationPassword(), validationEnabled);
    }

    public KafkaJmxAuthenticationPasswordBuilder(KafkaJmxAuthenticationPasswordFluent<?> fluent,KafkaJmxAuthenticationPassword instance) {
        this(fluent, instance, true);
    }

    public KafkaJmxAuthenticationPasswordBuilder(KafkaJmxAuthenticationPasswordFluent<?> fluent,KafkaJmxAuthenticationPassword instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        this.validationEnabled = validationEnabled; 
    }

    public KafkaJmxAuthenticationPasswordBuilder(KafkaJmxAuthenticationPassword instance) {
        this(instance,true);
    }

    public KafkaJmxAuthenticationPasswordBuilder(KafkaJmxAuthenticationPassword instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.validationEnabled = validationEnabled; 
    }

    public KafkaJmxAuthenticationPassword build() {
        KafkaJmxAuthenticationPassword buildable = new KafkaJmxAuthenticationPassword();
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaJmxAuthenticationPasswordBuilder that = (KafkaJmxAuthenticationPasswordBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
