package io.strimzi.api.kafka.model;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class KafkaMirrorMakerConsumerSpecFluentImpl<A extends KafkaMirrorMakerConsumerSpecFluent<A>> extends KafkaMirrorMakerClientSpecFluentImpl<A> implements KafkaMirrorMakerConsumerSpecFluent<A> {

    private Integer numStreams;
    private String groupId;
    private Integer offsetCommitInterval;

    public KafkaMirrorMakerConsumerSpecFluentImpl() {
    }

    public KafkaMirrorMakerConsumerSpecFluentImpl(KafkaMirrorMakerConsumerSpec instance) {
        this.withNumStreams(instance.getNumStreams());
        
        this.withGroupId(instance.getGroupId());
        
        this.withOffsetCommitInterval(instance.getOffsetCommitInterval());
        
        this.withBootstrapServers(instance.getBootstrapServers());
        
        this.withConfig(instance.getConfig());
        
        this.withTls(instance.getTls());
        
        this.withAuthentication(instance.getAuthentication());
    }

    public Integer getNumStreams() {
        return this.numStreams;
    }

    public A withNumStreams(Integer numStreams) {
        this.numStreams=numStreams; return (A) this;
    }

    public Boolean hasNumStreams() {
        return this.numStreams != null;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public A withGroupId(String groupId) {
        this.groupId=groupId; return (A) this;
    }

    public Boolean hasGroupId() {
        return this.groupId != null;
    }

    public A withNewGroupId(StringBuilder arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A withNewGroupId(int[] arg1,int arg2,int arg3) {
        return (A)withGroupId(new String(arg1, arg2, arg3));
    }

    public A withNewGroupId(char[] arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A withNewGroupId(StringBuffer arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A withNewGroupId(byte[] arg1,int arg2) {
        return (A)withGroupId(new String(arg1, arg2));
    }

    public A withNewGroupId(byte[] arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public A withNewGroupId(char[] arg1,int arg2,int arg3) {
        return (A)withGroupId(new String(arg1, arg2, arg3));
    }

    public A withNewGroupId(byte[] arg1,int arg2,int arg3) {
        return (A)withGroupId(new String(arg1, arg2, arg3));
    }

    public A withNewGroupId(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withGroupId(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewGroupId(String arg1) {
        return (A)withGroupId(new String(arg1));
    }

    public Integer getOffsetCommitInterval() {
        return this.offsetCommitInterval;
    }

    public A withOffsetCommitInterval(Integer offsetCommitInterval) {
        this.offsetCommitInterval=offsetCommitInterval; return (A) this;
    }

    public Boolean hasOffsetCommitInterval() {
        return this.offsetCommitInterval != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerConsumerSpecFluentImpl that = (KafkaMirrorMakerConsumerSpecFluentImpl) o;
        if (numStreams != null ? !numStreams.equals(that.numStreams) :that.numStreams != null) return false;
        if (groupId != null ? !groupId.equals(that.groupId) :that.groupId != null) return false;
        if (offsetCommitInterval != null ? !offsetCommitInterval.equals(that.offsetCommitInterval) :that.offsetCommitInterval != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(numStreams,  groupId,  offsetCommitInterval,  super.hashCode());
    }

}
