package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class KafkaMirrorMakerTlsFluentImpl<A extends KafkaMirrorMakerTlsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaMirrorMakerTlsFluent<A> {

    private java.util.List<CertSecretSourceBuilder> trustedCertificates;

    public KafkaMirrorMakerTlsFluentImpl() {
    }

    public KafkaMirrorMakerTlsFluentImpl(KafkaMirrorMakerTls instance) {
        this.withTrustedCertificates(instance.getTrustedCertificates());
    }

    public A addToTrustedCertificates(int index,CertSecretSource item) {
        if (this.trustedCertificates == null) {this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").add(index >= 0 ? index : _visitables.get("trustedCertificates").size(), builder);this.trustedCertificates.add(index >= 0 ? index : trustedCertificates.size(), builder); return (A)this;
    }

    public A setToTrustedCertificates(int index,CertSecretSource item) {
        if (this.trustedCertificates == null) {this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= _visitables.get("trustedCertificates").size()) { _visitables.get("trustedCertificates").add(builder); } else { _visitables.get("trustedCertificates").set(index, builder);}
        if (index < 0 || index >= trustedCertificates.size()) { trustedCertificates.add(builder); } else { trustedCertificates.set(index, builder);}
         return (A)this;
    }

    public A addToTrustedCertificates(CertSecretSource... items) {
        if (this.trustedCertificates == null) {this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
        for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").add(builder);this.trustedCertificates.add(builder);} return (A)this;
    }

    public A addAllToTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.trustedCertificates == null) {this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
        for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").add(builder);this.trustedCertificates.add(builder);} return (A)this;
    }

    public A removeFromTrustedCertificates(CertSecretSource... items) {
        for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").remove(builder);if (this.trustedCertificates != null) {this.trustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeAllFromTrustedCertificates(Collection<CertSecretSource> items) {
        for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("trustedCertificates").remove(builder);if (this.trustedCertificates != null) {this.trustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
        if (trustedCertificates == null) return (A) this;
        final Iterator<CertSecretSourceBuilder> each = trustedCertificates.iterator();
        final List visitables = _visitables.get("trustedCertificates");
        while (each.hasNext()) {
          CertSecretSourceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTrustedCertificates instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<CertSecretSource> getTrustedCertificates() {
        return build(trustedCertificates);
    }

    public java.util.List<CertSecretSource> buildTrustedCertificates() {
        return build(trustedCertificates);
    }

    public CertSecretSource buildTrustedCertificate(int index) {
        return this.trustedCertificates.get(index).build();
    }

    public CertSecretSource buildFirstTrustedCertificate() {
        return this.trustedCertificates.get(0).build();
    }

    public CertSecretSource buildLastTrustedCertificate() {
        return this.trustedCertificates.get(trustedCertificates.size() - 1).build();
    }

    public CertSecretSource buildMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item: trustedCertificates) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item: trustedCertificates) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTrustedCertificates(java.util.List<CertSecretSource> trustedCertificates) {
        if (this.trustedCertificates != null) { _visitables.get("trustedCertificates").removeAll(this.trustedCertificates);}
        if (trustedCertificates != null) {this.trustedCertificates = new ArrayList<CertSecretSourceBuilder>(); for (CertSecretSource item : trustedCertificates){this.addToTrustedCertificates(item);}} else { this.trustedCertificates = null;} return (A) this;
    }

    public A withTrustedCertificates(CertSecretSource... trustedCertificates) {
        if (this.trustedCertificates != null) {this.trustedCertificates.clear();}
        if (trustedCertificates != null) {for (CertSecretSource item :trustedCertificates){ this.addToTrustedCertificates(item);}} return (A) this;
    }

    public Boolean hasTrustedCertificates() {
        return trustedCertificates != null && !trustedCertificates.isEmpty();
    }

    public KafkaMirrorMakerTlsFluent.TrustedCertificatesNested<A> addNewTrustedCertificate() {
        return new TrustedCertificatesNestedImpl();
    }

    public KafkaMirrorMakerTlsFluent.TrustedCertificatesNested<A> addNewTrustedCertificateLike(CertSecretSource item) {
        return new TrustedCertificatesNestedImpl(-1, item);
    }

    public KafkaMirrorMakerTlsFluent.TrustedCertificatesNested<A> setNewTrustedCertificateLike(int index,CertSecretSource item) {
        return new TrustedCertificatesNestedImpl(index, item);
    }

    public KafkaMirrorMakerTlsFluent.TrustedCertificatesNested<A> editTrustedCertificate(int index) {
        if (trustedCertificates.size() <= index) throw new RuntimeException("Can't edit trustedCertificates. Index exceeds size.");
        return setNewTrustedCertificateLike(index, buildTrustedCertificate(index));
    }

    public KafkaMirrorMakerTlsFluent.TrustedCertificatesNested<A> editFirstTrustedCertificate() {
        if (trustedCertificates.size() == 0) throw new RuntimeException("Can't edit first trustedCertificates. The list is empty.");
        return setNewTrustedCertificateLike(0, buildTrustedCertificate(0));
    }

    public KafkaMirrorMakerTlsFluent.TrustedCertificatesNested<A> editLastTrustedCertificate() {
        int index = trustedCertificates.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last trustedCertificates. The list is empty.");
        return setNewTrustedCertificateLike(index, buildTrustedCertificate(index));
    }

    public KafkaMirrorMakerTlsFluent.TrustedCertificatesNested<A> editMatchingTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<trustedCertificates.size();i++) { 
        if (predicate.test(trustedCertificates.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching trustedCertificates. No match found.");
        return setNewTrustedCertificateLike(index, buildTrustedCertificate(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaMirrorMakerTlsFluentImpl that = (KafkaMirrorMakerTlsFluentImpl) o;
        if (trustedCertificates != null ? !trustedCertificates.equals(that.trustedCertificates) :that.trustedCertificates != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(trustedCertificates,  super.hashCode());
    }

    public class TrustedCertificatesNestedImpl<N> extends CertSecretSourceFluentImpl<KafkaMirrorMakerTlsFluent.TrustedCertificatesNested<N>> implements KafkaMirrorMakerTlsFluent.TrustedCertificatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CertSecretSourceBuilder builder;
        private final int index;

            TrustedCertificatesNestedImpl(int index,CertSecretSource item) {
                this.index = index;
                this.builder = new CertSecretSourceBuilder(this, item);
                        
            }

            TrustedCertificatesNestedImpl() {
                this.index = -1;
                this.builder = new CertSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMakerTlsFluentImpl.this.setToTrustedCertificates(index,builder.build());
            }

            public N endTrustedCertificate() {
                return and();
            }
    }


}
