package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaRebalanceBuilder extends KafkaRebalanceFluentImpl<KafkaRebalanceBuilder> implements VisitableBuilder<KafkaRebalance,KafkaRebalanceBuilder> {

    KafkaRebalanceFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaRebalanceBuilder() {
        this(true);
    }

    public KafkaRebalanceBuilder(Boolean validationEnabled) {
        this(new KafkaRebalance(), validationEnabled);
    }

    public KafkaRebalanceBuilder(KafkaRebalanceFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaRebalanceBuilder(KafkaRebalanceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaRebalance(), validationEnabled);
    }

    public KafkaRebalanceBuilder(KafkaRebalanceFluent<?> fluent,KafkaRebalance instance) {
        this(fluent, instance, true);
    }

    public KafkaRebalanceBuilder(KafkaRebalanceFluent<?> fluent,KafkaRebalance instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion());
        
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withSpec(instance.getSpec());
        
        fluent.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaRebalanceBuilder(KafkaRebalance instance) {
        this(instance,true);
    }

    public KafkaRebalanceBuilder(KafkaRebalance instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaRebalance build() {
        KafkaRebalance buildable = new KafkaRebalance();
        buildable.setApiVersion(fluent.getApiVersion());
        buildable.setMetadata(fluent.getMetadata());
        buildable.setSpec(fluent.getSpec());
        buildable.setStatus(fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaRebalanceBuilder that = (KafkaRebalanceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
