package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.strimzi.api.kafka.model.status.KafkaRebalanceStatus;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.strimzi.api.kafka.model.status.KafkaRebalanceStatusFluent;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.status.KafkaRebalanceStatusBuilder;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KafkaRebalanceFluent<A extends KafkaRebalanceFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(int[] arg1,int arg2,int arg3);
    public A withNewApiVersion(char[] arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A withNewApiVersion(byte[] arg1,int arg2);
    public A withNewApiVersion(byte[] arg1);
    public A withNewApiVersion(char[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3);
    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewApiVersion(String arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public KafkaRebalanceFluent.MetadataNested<A> withNewMetadata();
    public KafkaRebalanceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public KafkaRebalanceFluent.MetadataNested<A> editMetadata();
    public KafkaRebalanceFluent.MetadataNested<A> editOrNewMetadata();
    public KafkaRebalanceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaRebalanceSpec getSpec();
    public KafkaRebalanceSpec buildSpec();
    public A withSpec(KafkaRebalanceSpec spec);
    public Boolean hasSpec();
    public KafkaRebalanceFluent.SpecNested<A> withNewSpec();
    public KafkaRebalanceFluent.SpecNested<A> withNewSpecLike(KafkaRebalanceSpec item);
    public KafkaRebalanceFluent.SpecNested<A> editSpec();
    public KafkaRebalanceFluent.SpecNested<A> editOrNewSpec();
    public KafkaRebalanceFluent.SpecNested<A> editOrNewSpecLike(KafkaRebalanceSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaRebalanceStatus getStatus();
    public KafkaRebalanceStatus buildStatus();
    public A withStatus(KafkaRebalanceStatus status);
    public Boolean hasStatus();
    public KafkaRebalanceFluent.StatusNested<A> withNewStatus();
    public KafkaRebalanceFluent.StatusNested<A> withNewStatusLike(KafkaRebalanceStatus item);
    public KafkaRebalanceFluent.StatusNested<A> editStatus();
    public KafkaRebalanceFluent.StatusNested<A> editOrNewStatus();
    public KafkaRebalanceFluent.StatusNested<A> editOrNewStatusLike(KafkaRebalanceStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<KafkaRebalanceFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaRebalanceSpecFluent<KafkaRebalanceFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaRebalanceStatusFluent<KafkaRebalanceFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
