package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.status.KafkaRebalanceStatus;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.status.KafkaRebalanceStatusBuilder;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.strimzi.api.kafka.model.status.KafkaRebalanceStatusFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class KafkaRebalanceFluentImpl<A extends KafkaRebalanceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaRebalanceFluent<A> {

    private String apiVersion;
    private ObjectMetaBuilder metadata;
    private KafkaRebalanceSpecBuilder spec;
    private KafkaRebalanceStatusBuilder status;

    public KafkaRebalanceFluentImpl() {
    }

    public KafkaRebalanceFluentImpl(KafkaRebalance instance) {
        this.withApiVersion(instance.getApiVersion());
        
        this.withMetadata(instance.getMetadata());
        
        this.withSpec(instance.getSpec());
        
        this.withStatus(instance.getStatus());
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public KafkaRebalanceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public KafkaRebalanceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public KafkaRebalanceFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public KafkaRebalanceFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public KafkaRebalanceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaRebalanceSpec getSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public KafkaRebalanceSpec buildSpec() {
        return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(KafkaRebalanceSpec spec) {
        _visitables.get("spec").remove(this.spec);
        if (spec!=null){ this.spec= new KafkaRebalanceSpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec() {
        return this.spec != null;
    }

    public KafkaRebalanceFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    public KafkaRebalanceFluent.SpecNested<A> withNewSpecLike(KafkaRebalanceSpec item) {
        return new SpecNestedImpl(item);
    }

    public KafkaRebalanceFluent.SpecNested<A> editSpec() {
        return withNewSpecLike(getSpec());
    }

    public KafkaRebalanceFluent.SpecNested<A> editOrNewSpec() {
        return withNewSpecLike(getSpec() != null ? getSpec(): new KafkaRebalanceSpecBuilder().build());
    }

    public KafkaRebalanceFluent.SpecNested<A> editOrNewSpecLike(KafkaRebalanceSpec item) {
        return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaRebalanceStatus getStatus() {
        return this.status!=null?this.status.build():null;
    }

    public KafkaRebalanceStatus buildStatus() {
        return this.status!=null?this.status.build():null;
    }

    public A withStatus(KafkaRebalanceStatus status) {
        _visitables.get("status").remove(this.status);
        if (status!=null){ this.status= new KafkaRebalanceStatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus() {
        return this.status != null;
    }

    public KafkaRebalanceFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    public KafkaRebalanceFluent.StatusNested<A> withNewStatusLike(KafkaRebalanceStatus item) {
        return new StatusNestedImpl(item);
    }

    public KafkaRebalanceFluent.StatusNested<A> editStatus() {
        return withNewStatusLike(getStatus());
    }

    public KafkaRebalanceFluent.StatusNested<A> editOrNewStatus() {
        return withNewStatusLike(getStatus() != null ? getStatus(): new KafkaRebalanceStatusBuilder().build());
    }

    public KafkaRebalanceFluent.StatusNested<A> editOrNewStatusLike(KafkaRebalanceStatus item) {
        return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaRebalanceFluentImpl that = (KafkaRebalanceFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
        if (status != null ? !status.equals(that.status) :that.status != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  metadata,  spec,  status,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<KafkaRebalanceFluent.MetadataNested<N>> implements KafkaRebalanceFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaRebalanceFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class SpecNestedImpl<N> extends KafkaRebalanceSpecFluentImpl<KafkaRebalanceFluent.SpecNested<N>> implements KafkaRebalanceFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaRebalanceSpecBuilder builder;

            SpecNestedImpl(KafkaRebalanceSpec item) {
                this.builder = new KafkaRebalanceSpecBuilder(this, item);
                        
            }

            SpecNestedImpl() {
                this.builder = new KafkaRebalanceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaRebalanceFluentImpl.this.withSpec(builder.build());
            }

            public N endSpec() {
                return and();
            }
    }


    public class StatusNestedImpl<N> extends KafkaRebalanceStatusFluentImpl<KafkaRebalanceFluent.StatusNested<N>> implements KafkaRebalanceFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaRebalanceStatusBuilder builder;

            StatusNestedImpl(KafkaRebalanceStatus item) {
                this.builder = new KafkaRebalanceStatusBuilder(this, item);
                        
            }

            StatusNestedImpl() {
                this.builder = new KafkaRebalanceStatusBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaRebalanceFluentImpl.this.withStatus(builder.build());
            }

            public N endStatus() {
                return and();
            }
    }


}
