package io.strimzi.api.kafka.model;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import java.util.function.Predicate;

public interface KafkaRebalanceSpecFluent<A extends KafkaRebalanceSpecFluent<A>> extends SpecFluent<A> {


    public A addToGoals(int index,String item);
    public A setToGoals(int index,String item);
    public A addToGoals(String... items);
    public A addAllToGoals(Collection<String> items);
    public A removeFromGoals(String... items);
    public A removeAllFromGoals(Collection<String> items);
    public java.util.List<String> getGoals();
    public String getGoal(int index);
    public String getFirstGoal();
    public String getLastGoal();
    public String getMatchingGoal(Predicate<String> predicate);
    public Boolean hasMatchingGoal(Predicate<String> predicate);
    public A withGoals(java.util.List<String> goals);
    public A withGoals(String... goals);
    public Boolean hasGoals();
    public A addNewGoal(StringBuilder arg1);
    public A addNewGoal(int[] arg1,int arg2,int arg3);
    public A addNewGoal(char[] arg1);
    public A addNewGoal(StringBuffer arg1);
    public A addNewGoal(byte[] arg1,int arg2);
    public A addNewGoal(byte[] arg1);
    public A addNewGoal(char[] arg1,int arg2,int arg3);
    public A addNewGoal(byte[] arg1,int arg2,int arg3);
    public A addNewGoal(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewGoal(String arg1);
    public boolean isSkipHardGoalCheck();
    public A withSkipHardGoalCheck(boolean skipHardGoalCheck);
    public Boolean hasSkipHardGoalCheck();
    public String getExcludedTopics();
    public A withExcludedTopics(String excludedTopics);
    public Boolean hasExcludedTopics();
    public A withNewExcludedTopics(StringBuilder arg1);
    public A withNewExcludedTopics(int[] arg1,int arg2,int arg3);
    public A withNewExcludedTopics(char[] arg1);
    public A withNewExcludedTopics(StringBuffer arg1);
    public A withNewExcludedTopics(byte[] arg1,int arg2);
    public A withNewExcludedTopics(byte[] arg1);
    public A withNewExcludedTopics(char[] arg1,int arg2,int arg3);
    public A withNewExcludedTopics(byte[] arg1,int arg2,int arg3);
    public A withNewExcludedTopics(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewExcludedTopics(String arg1);
    public int getConcurrentPartitionMovementsPerBroker();
    public A withConcurrentPartitionMovementsPerBroker(int concurrentPartitionMovementsPerBroker);
    public Boolean hasConcurrentPartitionMovementsPerBroker();
    public int getConcurrentIntraBrokerPartitionMovements();
    public A withConcurrentIntraBrokerPartitionMovements(int concurrentIntraBrokerPartitionMovements);
    public Boolean hasConcurrentIntraBrokerPartitionMovements();
    public int getConcurrentLeaderMovements();
    public A withConcurrentLeaderMovements(int concurrentLeaderMovements);
    public Boolean hasConcurrentLeaderMovements();
    public long getReplicationThrottle();
    public A withReplicationThrottle(long replicationThrottle);
    public Boolean hasReplicationThrottle();
    public A addToReplicaMovementStrategies(int index,String item);
    public A setToReplicaMovementStrategies(int index,String item);
    public A addToReplicaMovementStrategies(String... items);
    public A addAllToReplicaMovementStrategies(Collection<String> items);
    public A removeFromReplicaMovementStrategies(String... items);
    public A removeAllFromReplicaMovementStrategies(Collection<String> items);
    public java.util.List<String> getReplicaMovementStrategies();
    public String getReplicaMovementStrategy(int index);
    public String getFirstReplicaMovementStrategy();
    public String getLastReplicaMovementStrategy();
    public String getMatchingReplicaMovementStrategy(Predicate<String> predicate);
    public Boolean hasMatchingReplicaMovementStrategy(Predicate<String> predicate);
    public A withReplicaMovementStrategies(java.util.List<String> replicaMovementStrategies);
    public A withReplicaMovementStrategies(String... replicaMovementStrategies);
    public Boolean hasReplicaMovementStrategies();
    public A addNewReplicaMovementStrategy(StringBuilder arg1);
    public A addNewReplicaMovementStrategy(int[] arg1,int arg2,int arg3);
    public A addNewReplicaMovementStrategy(char[] arg1);
    public A addNewReplicaMovementStrategy(StringBuffer arg1);
    public A addNewReplicaMovementStrategy(byte[] arg1,int arg2);
    public A addNewReplicaMovementStrategy(byte[] arg1);
    public A addNewReplicaMovementStrategy(char[] arg1,int arg2,int arg3);
    public A addNewReplicaMovementStrategy(byte[] arg1,int arg2,int arg3);
    public A addNewReplicaMovementStrategy(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewReplicaMovementStrategy(String arg1);
}
