package io.strimzi.api.kafka.model;

import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.lang.StringBuffer;

public class KafkaSpecFluentImpl<A extends KafkaSpecFluent<A>> extends SpecFluentImpl<A> implements KafkaSpecFluent<A> {

    private KafkaClusterSpecBuilder kafka;
    private ZookeeperClusterSpecBuilder zookeeper;
    private TopicOperatorSpecBuilder topicOperator;
    private EntityOperatorSpecBuilder entityOperator;
    private CertificateAuthorityBuilder clusterCa;
    private JmxTransSpecBuilder jmxTrans;
    private KafkaExporterSpecBuilder kafkaExporter;
    private CruiseControlSpecBuilder cruiseControl;
    private CertificateAuthorityBuilder clientsCa;
    private java.util.List<String> maintenanceTimeWindows;

    public KafkaSpecFluentImpl() {
    }

    public KafkaSpecFluentImpl(KafkaSpec instance) {
        this.withKafka(instance.getKafka());
        
        this.withZookeeper(instance.getZookeeper());
        
        this.withTopicOperator(instance.getTopicOperator());
        
        this.withEntityOperator(instance.getEntityOperator());
        
        this.withClusterCa(instance.getClusterCa());
        
        this.withJmxTrans(instance.getJmxTrans());
        
        this.withKafkaExporter(instance.getKafkaExporter());
        
        this.withCruiseControl(instance.getCruiseControl());
        
        this.withClientsCa(instance.getClientsCa());
        
        this.withMaintenanceTimeWindows(instance.getMaintenanceTimeWindows());
    }

    
/**
 * This method has been deprecated, please use method buildKafka instead.
 * @return The buildable object.
 */
@Deprecated public KafkaClusterSpec getKafka() {
        return this.kafka!=null?this.kafka.build():null;
    }

    public KafkaClusterSpec buildKafka() {
        return this.kafka!=null?this.kafka.build():null;
    }

    public A withKafka(KafkaClusterSpec kafka) {
        _visitables.get("kafka").remove(this.kafka);
        if (kafka!=null){ this.kafka= new KafkaClusterSpecBuilder(kafka); _visitables.get("kafka").add(this.kafka);} return (A) this;
    }

    public Boolean hasKafka() {
        return this.kafka != null;
    }

    public KafkaSpecFluent.KafkaNested<A> withNewKafka() {
        return new KafkaNestedImpl();
    }

    public KafkaSpecFluent.KafkaNested<A> withNewKafkaLike(KafkaClusterSpec item) {
        return new KafkaNestedImpl(item);
    }

    public KafkaSpecFluent.KafkaNested<A> editKafka() {
        return withNewKafkaLike(getKafka());
    }

    public KafkaSpecFluent.KafkaNested<A> editOrNewKafka() {
        return withNewKafkaLike(getKafka() != null ? getKafka(): new KafkaClusterSpecBuilder().build());
    }

    public KafkaSpecFluent.KafkaNested<A> editOrNewKafkaLike(KafkaClusterSpec item) {
        return withNewKafkaLike(getKafka() != null ? getKafka(): item);
    }

    
/**
 * This method has been deprecated, please use method buildZookeeper instead.
 * @return The buildable object.
 */
@Deprecated public ZookeeperClusterSpec getZookeeper() {
        return this.zookeeper!=null?this.zookeeper.build():null;
    }

    public ZookeeperClusterSpec buildZookeeper() {
        return this.zookeeper!=null?this.zookeeper.build():null;
    }

    public A withZookeeper(ZookeeperClusterSpec zookeeper) {
        _visitables.get("zookeeper").remove(this.zookeeper);
        if (zookeeper!=null){ this.zookeeper= new ZookeeperClusterSpecBuilder(zookeeper); _visitables.get("zookeeper").add(this.zookeeper);} return (A) this;
    }

    public Boolean hasZookeeper() {
        return this.zookeeper != null;
    }

    public KafkaSpecFluent.ZookeeperNested<A> withNewZookeeper() {
        return new ZookeeperNestedImpl();
    }

    public KafkaSpecFluent.ZookeeperNested<A> withNewZookeeperLike(ZookeeperClusterSpec item) {
        return new ZookeeperNestedImpl(item);
    }

    public KafkaSpecFluent.ZookeeperNested<A> editZookeeper() {
        return withNewZookeeperLike(getZookeeper());
    }

    public KafkaSpecFluent.ZookeeperNested<A> editOrNewZookeeper() {
        return withNewZookeeperLike(getZookeeper() != null ? getZookeeper(): new ZookeeperClusterSpecBuilder().build());
    }

    public KafkaSpecFluent.ZookeeperNested<A> editOrNewZookeeperLike(ZookeeperClusterSpec item) {
        return withNewZookeeperLike(getZookeeper() != null ? getZookeeper(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTopicOperator instead.
 * @return The buildable object.
 */
@Deprecated public TopicOperatorSpec getTopicOperator() {
        return this.topicOperator!=null?this.topicOperator.build():null;
    }

    public TopicOperatorSpec buildTopicOperator() {
        return this.topicOperator!=null?this.topicOperator.build():null;
    }

    public A withTopicOperator(TopicOperatorSpec topicOperator) {
        _visitables.get("topicOperator").remove(this.topicOperator);
        if (topicOperator!=null){ this.topicOperator= new TopicOperatorSpecBuilder(topicOperator); _visitables.get("topicOperator").add(this.topicOperator);} return (A) this;
    }

    public Boolean hasTopicOperator() {
        return this.topicOperator != null;
    }

    public KafkaSpecFluent.TopicOperatorNested<A> withNewTopicOperator() {
        return new TopicOperatorNestedImpl();
    }

    public KafkaSpecFluent.TopicOperatorNested<A> withNewTopicOperatorLike(TopicOperatorSpec item) {
        return new TopicOperatorNestedImpl(item);
    }

    public KafkaSpecFluent.TopicOperatorNested<A> editTopicOperator() {
        return withNewTopicOperatorLike(getTopicOperator());
    }

    public KafkaSpecFluent.TopicOperatorNested<A> editOrNewTopicOperator() {
        return withNewTopicOperatorLike(getTopicOperator() != null ? getTopicOperator(): new TopicOperatorSpecBuilder().build());
    }

    public KafkaSpecFluent.TopicOperatorNested<A> editOrNewTopicOperatorLike(TopicOperatorSpec item) {
        return withNewTopicOperatorLike(getTopicOperator() != null ? getTopicOperator(): item);
    }

    
/**
 * This method has been deprecated, please use method buildEntityOperator instead.
 * @return The buildable object.
 */
@Deprecated public EntityOperatorSpec getEntityOperator() {
        return this.entityOperator!=null?this.entityOperator.build():null;
    }

    public EntityOperatorSpec buildEntityOperator() {
        return this.entityOperator!=null?this.entityOperator.build():null;
    }

    public A withEntityOperator(EntityOperatorSpec entityOperator) {
        _visitables.get("entityOperator").remove(this.entityOperator);
        if (entityOperator!=null){ this.entityOperator= new EntityOperatorSpecBuilder(entityOperator); _visitables.get("entityOperator").add(this.entityOperator);} return (A) this;
    }

    public Boolean hasEntityOperator() {
        return this.entityOperator != null;
    }

    public KafkaSpecFluent.EntityOperatorNested<A> withNewEntityOperator() {
        return new EntityOperatorNestedImpl();
    }

    public KafkaSpecFluent.EntityOperatorNested<A> withNewEntityOperatorLike(EntityOperatorSpec item) {
        return new EntityOperatorNestedImpl(item);
    }

    public KafkaSpecFluent.EntityOperatorNested<A> editEntityOperator() {
        return withNewEntityOperatorLike(getEntityOperator());
    }

    public KafkaSpecFluent.EntityOperatorNested<A> editOrNewEntityOperator() {
        return withNewEntityOperatorLike(getEntityOperator() != null ? getEntityOperator(): new EntityOperatorSpecBuilder().build());
    }

    public KafkaSpecFluent.EntityOperatorNested<A> editOrNewEntityOperatorLike(EntityOperatorSpec item) {
        return withNewEntityOperatorLike(getEntityOperator() != null ? getEntityOperator(): item);
    }

    
/**
 * This method has been deprecated, please use method buildClusterCa instead.
 * @return The buildable object.
 */
@Deprecated public CertificateAuthority getClusterCa() {
        return this.clusterCa!=null?this.clusterCa.build():null;
    }

    public CertificateAuthority buildClusterCa() {
        return this.clusterCa!=null?this.clusterCa.build():null;
    }

    public A withClusterCa(CertificateAuthority clusterCa) {
        _visitables.get("clusterCa").remove(this.clusterCa);
        if (clusterCa!=null){ this.clusterCa= new CertificateAuthorityBuilder(clusterCa); _visitables.get("clusterCa").add(this.clusterCa);} return (A) this;
    }

    public Boolean hasClusterCa() {
        return this.clusterCa != null;
    }

    public KafkaSpecFluent.ClusterCaNested<A> withNewClusterCa() {
        return new ClusterCaNestedImpl();
    }

    public KafkaSpecFluent.ClusterCaNested<A> withNewClusterCaLike(CertificateAuthority item) {
        return new ClusterCaNestedImpl(item);
    }

    public KafkaSpecFluent.ClusterCaNested<A> editClusterCa() {
        return withNewClusterCaLike(getClusterCa());
    }

    public KafkaSpecFluent.ClusterCaNested<A> editOrNewClusterCa() {
        return withNewClusterCaLike(getClusterCa() != null ? getClusterCa(): new CertificateAuthorityBuilder().build());
    }

    public KafkaSpecFluent.ClusterCaNested<A> editOrNewClusterCaLike(CertificateAuthority item) {
        return withNewClusterCaLike(getClusterCa() != null ? getClusterCa(): item);
    }

    
/**
 * This method has been deprecated, please use method buildJmxTrans instead.
 * @return The buildable object.
 */
@Deprecated public JmxTransSpec getJmxTrans() {
        return this.jmxTrans!=null?this.jmxTrans.build():null;
    }

    public JmxTransSpec buildJmxTrans() {
        return this.jmxTrans!=null?this.jmxTrans.build():null;
    }

    public A withJmxTrans(JmxTransSpec jmxTrans) {
        _visitables.get("jmxTrans").remove(this.jmxTrans);
        if (jmxTrans!=null){ this.jmxTrans= new JmxTransSpecBuilder(jmxTrans); _visitables.get("jmxTrans").add(this.jmxTrans);} return (A) this;
    }

    public Boolean hasJmxTrans() {
        return this.jmxTrans != null;
    }

    public KafkaSpecFluent.JmxTransNested<A> withNewJmxTrans() {
        return new JmxTransNestedImpl();
    }

    public KafkaSpecFluent.JmxTransNested<A> withNewJmxTransLike(JmxTransSpec item) {
        return new JmxTransNestedImpl(item);
    }

    public KafkaSpecFluent.JmxTransNested<A> editJmxTrans() {
        return withNewJmxTransLike(getJmxTrans());
    }

    public KafkaSpecFluent.JmxTransNested<A> editOrNewJmxTrans() {
        return withNewJmxTransLike(getJmxTrans() != null ? getJmxTrans(): new JmxTransSpecBuilder().build());
    }

    public KafkaSpecFluent.JmxTransNested<A> editOrNewJmxTransLike(JmxTransSpec item) {
        return withNewJmxTransLike(getJmxTrans() != null ? getJmxTrans(): item);
    }

    
/**
 * This method has been deprecated, please use method buildKafkaExporter instead.
 * @return The buildable object.
 */
@Deprecated public KafkaExporterSpec getKafkaExporter() {
        return this.kafkaExporter!=null?this.kafkaExporter.build():null;
    }

    public KafkaExporterSpec buildKafkaExporter() {
        return this.kafkaExporter!=null?this.kafkaExporter.build():null;
    }

    public A withKafkaExporter(KafkaExporterSpec kafkaExporter) {
        _visitables.get("kafkaExporter").remove(this.kafkaExporter);
        if (kafkaExporter!=null){ this.kafkaExporter= new KafkaExporterSpecBuilder(kafkaExporter); _visitables.get("kafkaExporter").add(this.kafkaExporter);} return (A) this;
    }

    public Boolean hasKafkaExporter() {
        return this.kafkaExporter != null;
    }

    public KafkaSpecFluent.KafkaExporterNested<A> withNewKafkaExporter() {
        return new KafkaExporterNestedImpl();
    }

    public KafkaSpecFluent.KafkaExporterNested<A> withNewKafkaExporterLike(KafkaExporterSpec item) {
        return new KafkaExporterNestedImpl(item);
    }

    public KafkaSpecFluent.KafkaExporterNested<A> editKafkaExporter() {
        return withNewKafkaExporterLike(getKafkaExporter());
    }

    public KafkaSpecFluent.KafkaExporterNested<A> editOrNewKafkaExporter() {
        return withNewKafkaExporterLike(getKafkaExporter() != null ? getKafkaExporter(): new KafkaExporterSpecBuilder().build());
    }

    public KafkaSpecFluent.KafkaExporterNested<A> editOrNewKafkaExporterLike(KafkaExporterSpec item) {
        return withNewKafkaExporterLike(getKafkaExporter() != null ? getKafkaExporter(): item);
    }

    
/**
 * This method has been deprecated, please use method buildCruiseControl instead.
 * @return The buildable object.
 */
@Deprecated public CruiseControlSpec getCruiseControl() {
        return this.cruiseControl!=null?this.cruiseControl.build():null;
    }

    public CruiseControlSpec buildCruiseControl() {
        return this.cruiseControl!=null?this.cruiseControl.build():null;
    }

    public A withCruiseControl(CruiseControlSpec cruiseControl) {
        _visitables.get("cruiseControl").remove(this.cruiseControl);
        if (cruiseControl!=null){ this.cruiseControl= new CruiseControlSpecBuilder(cruiseControl); _visitables.get("cruiseControl").add(this.cruiseControl);} return (A) this;
    }

    public Boolean hasCruiseControl() {
        return this.cruiseControl != null;
    }

    public KafkaSpecFluent.CruiseControlNested<A> withNewCruiseControl() {
        return new CruiseControlNestedImpl();
    }

    public KafkaSpecFluent.CruiseControlNested<A> withNewCruiseControlLike(CruiseControlSpec item) {
        return new CruiseControlNestedImpl(item);
    }

    public KafkaSpecFluent.CruiseControlNested<A> editCruiseControl() {
        return withNewCruiseControlLike(getCruiseControl());
    }

    public KafkaSpecFluent.CruiseControlNested<A> editOrNewCruiseControl() {
        return withNewCruiseControlLike(getCruiseControl() != null ? getCruiseControl(): new CruiseControlSpecBuilder().build());
    }

    public KafkaSpecFluent.CruiseControlNested<A> editOrNewCruiseControlLike(CruiseControlSpec item) {
        return withNewCruiseControlLike(getCruiseControl() != null ? getCruiseControl(): item);
    }

    
/**
 * This method has been deprecated, please use method buildClientsCa instead.
 * @return The buildable object.
 */
@Deprecated public CertificateAuthority getClientsCa() {
        return this.clientsCa!=null?this.clientsCa.build():null;
    }

    public CertificateAuthority buildClientsCa() {
        return this.clientsCa!=null?this.clientsCa.build():null;
    }

    public A withClientsCa(CertificateAuthority clientsCa) {
        _visitables.get("clientsCa").remove(this.clientsCa);
        if (clientsCa!=null){ this.clientsCa= new CertificateAuthorityBuilder(clientsCa); _visitables.get("clientsCa").add(this.clientsCa);} return (A) this;
    }

    public Boolean hasClientsCa() {
        return this.clientsCa != null;
    }

    public KafkaSpecFluent.ClientsCaNested<A> withNewClientsCa() {
        return new ClientsCaNestedImpl();
    }

    public KafkaSpecFluent.ClientsCaNested<A> withNewClientsCaLike(CertificateAuthority item) {
        return new ClientsCaNestedImpl(item);
    }

    public KafkaSpecFluent.ClientsCaNested<A> editClientsCa() {
        return withNewClientsCaLike(getClientsCa());
    }

    public KafkaSpecFluent.ClientsCaNested<A> editOrNewClientsCa() {
        return withNewClientsCaLike(getClientsCa() != null ? getClientsCa(): new CertificateAuthorityBuilder().build());
    }

    public KafkaSpecFluent.ClientsCaNested<A> editOrNewClientsCaLike(CertificateAuthority item) {
        return withNewClientsCaLike(getClientsCa() != null ? getClientsCa(): item);
    }

    public A addToMaintenanceTimeWindows(int index,String item) {
        if (this.maintenanceTimeWindows == null) {this.maintenanceTimeWindows = new ArrayList<String>();}
        this.maintenanceTimeWindows.add(index, item);
        return (A)this;
    }

    public A setToMaintenanceTimeWindows(int index,String item) {
        if (this.maintenanceTimeWindows == null) {this.maintenanceTimeWindows = new ArrayList<String>();}
        this.maintenanceTimeWindows.set(index, item); return (A)this;
    }

    public A addToMaintenanceTimeWindows(String... items) {
        if (this.maintenanceTimeWindows == null) {this.maintenanceTimeWindows = new ArrayList<String>();}
        for (String item : items) {this.maintenanceTimeWindows.add(item);} return (A)this;
    }

    public A addAllToMaintenanceTimeWindows(Collection<String> items) {
        if (this.maintenanceTimeWindows == null) {this.maintenanceTimeWindows = new ArrayList<String>();}
        for (String item : items) {this.maintenanceTimeWindows.add(item);} return (A)this;
    }

    public A removeFromMaintenanceTimeWindows(String... items) {
        for (String item : items) {if (this.maintenanceTimeWindows!= null){ this.maintenanceTimeWindows.remove(item);}} return (A)this;
    }

    public A removeAllFromMaintenanceTimeWindows(Collection<String> items) {
        for (String item : items) {if (this.maintenanceTimeWindows!= null){ this.maintenanceTimeWindows.remove(item);}} return (A)this;
    }

    public java.util.List<String> getMaintenanceTimeWindows() {
        return this.maintenanceTimeWindows;
    }

    public String getMaintenanceTimeWindow(int index) {
        return this.maintenanceTimeWindows.get(index);
    }

    public String getFirstMaintenanceTimeWindow() {
        return this.maintenanceTimeWindows.get(0);
    }

    public String getLastMaintenanceTimeWindow() {
        return this.maintenanceTimeWindows.get(maintenanceTimeWindows.size() - 1);
    }

    public String getMatchingMaintenanceTimeWindow(Predicate<String> predicate) {
        for (String item: maintenanceTimeWindows) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingMaintenanceTimeWindow(Predicate<String> predicate) {
        for (String item: maintenanceTimeWindows) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withMaintenanceTimeWindows(java.util.List<String> maintenanceTimeWindows) {
        if (this.maintenanceTimeWindows != null) { _visitables.get("maintenanceTimeWindows").removeAll(this.maintenanceTimeWindows);}
        if (maintenanceTimeWindows != null) {this.maintenanceTimeWindows = new ArrayList<String>(); for (String item : maintenanceTimeWindows){this.addToMaintenanceTimeWindows(item);}} else { this.maintenanceTimeWindows = null;} return (A) this;
    }

    public A withMaintenanceTimeWindows(String... maintenanceTimeWindows) {
        if (this.maintenanceTimeWindows != null) {this.maintenanceTimeWindows.clear();}
        if (maintenanceTimeWindows != null) {for (String item :maintenanceTimeWindows){ this.addToMaintenanceTimeWindows(item);}} return (A) this;
    }

    public Boolean hasMaintenanceTimeWindows() {
        return maintenanceTimeWindows != null && !maintenanceTimeWindows.isEmpty();
    }

    public A addNewMaintenanceTimeWindow(StringBuilder arg1) {
        return (A)addToMaintenanceTimeWindows(new String(arg1));
    }

    public A addNewMaintenanceTimeWindow(int[] arg1,int arg2,int arg3) {
        return (A)addToMaintenanceTimeWindows(new String(arg1, arg2, arg3));
    }

    public A addNewMaintenanceTimeWindow(char[] arg1) {
        return (A)addToMaintenanceTimeWindows(new String(arg1));
    }

    public A addNewMaintenanceTimeWindow(StringBuffer arg1) {
        return (A)addToMaintenanceTimeWindows(new String(arg1));
    }

    public A addNewMaintenanceTimeWindow(byte[] arg1,int arg2) {
        return (A)addToMaintenanceTimeWindows(new String(arg1, arg2));
    }

    public A addNewMaintenanceTimeWindow(byte[] arg1) {
        return (A)addToMaintenanceTimeWindows(new String(arg1));
    }

    public A addNewMaintenanceTimeWindow(char[] arg1,int arg2,int arg3) {
        return (A)addToMaintenanceTimeWindows(new String(arg1, arg2, arg3));
    }

    public A addNewMaintenanceTimeWindow(byte[] arg1,int arg2,int arg3) {
        return (A)addToMaintenanceTimeWindows(new String(arg1, arg2, arg3));
    }

    public A addNewMaintenanceTimeWindow(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToMaintenanceTimeWindows(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewMaintenanceTimeWindow(String arg1) {
        return (A)addToMaintenanceTimeWindows(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaSpecFluentImpl that = (KafkaSpecFluentImpl) o;
        if (kafka != null ? !kafka.equals(that.kafka) :that.kafka != null) return false;
        if (zookeeper != null ? !zookeeper.equals(that.zookeeper) :that.zookeeper != null) return false;
        if (topicOperator != null ? !topicOperator.equals(that.topicOperator) :that.topicOperator != null) return false;
        if (entityOperator != null ? !entityOperator.equals(that.entityOperator) :that.entityOperator != null) return false;
        if (clusterCa != null ? !clusterCa.equals(that.clusterCa) :that.clusterCa != null) return false;
        if (jmxTrans != null ? !jmxTrans.equals(that.jmxTrans) :that.jmxTrans != null) return false;
        if (kafkaExporter != null ? !kafkaExporter.equals(that.kafkaExporter) :that.kafkaExporter != null) return false;
        if (cruiseControl != null ? !cruiseControl.equals(that.cruiseControl) :that.cruiseControl != null) return false;
        if (clientsCa != null ? !clientsCa.equals(that.clientsCa) :that.clientsCa != null) return false;
        if (maintenanceTimeWindows != null ? !maintenanceTimeWindows.equals(that.maintenanceTimeWindows) :that.maintenanceTimeWindows != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(kafka,  zookeeper,  topicOperator,  entityOperator,  clusterCa,  jmxTrans,  kafkaExporter,  cruiseControl,  clientsCa,  maintenanceTimeWindows,  super.hashCode());
    }

    public class KafkaNestedImpl<N> extends KafkaClusterSpecFluentImpl<KafkaSpecFluent.KafkaNested<N>> implements KafkaSpecFluent.KafkaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaClusterSpecBuilder builder;

            KafkaNestedImpl(KafkaClusterSpec item) {
                this.builder = new KafkaClusterSpecBuilder(this, item);
                        
            }

            KafkaNestedImpl() {
                this.builder = new KafkaClusterSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withKafka(builder.build());
            }

            public N endKafka() {
                return and();
            }
    }


    public class ZookeeperNestedImpl<N> extends ZookeeperClusterSpecFluentImpl<KafkaSpecFluent.ZookeeperNested<N>> implements KafkaSpecFluent.ZookeeperNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ZookeeperClusterSpecBuilder builder;

            ZookeeperNestedImpl(ZookeeperClusterSpec item) {
                this.builder = new ZookeeperClusterSpecBuilder(this, item);
                        
            }

            ZookeeperNestedImpl() {
                this.builder = new ZookeeperClusterSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withZookeeper(builder.build());
            }

            public N endZookeeper() {
                return and();
            }
    }


    public class TopicOperatorNestedImpl<N> extends TopicOperatorSpecFluentImpl<KafkaSpecFluent.TopicOperatorNested<N>> implements KafkaSpecFluent.TopicOperatorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final TopicOperatorSpecBuilder builder;

            TopicOperatorNestedImpl(TopicOperatorSpec item) {
                this.builder = new TopicOperatorSpecBuilder(this, item);
                        
            }

            TopicOperatorNestedImpl() {
                this.builder = new TopicOperatorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withTopicOperator(builder.build());
            }

            public N endTopicOperator() {
                return and();
            }
    }


    public class EntityOperatorNestedImpl<N> extends EntityOperatorSpecFluentImpl<KafkaSpecFluent.EntityOperatorNested<N>> implements KafkaSpecFluent.EntityOperatorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final EntityOperatorSpecBuilder builder;

            EntityOperatorNestedImpl(EntityOperatorSpec item) {
                this.builder = new EntityOperatorSpecBuilder(this, item);
                        
            }

            EntityOperatorNestedImpl() {
                this.builder = new EntityOperatorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withEntityOperator(builder.build());
            }

            public N endEntityOperator() {
                return and();
            }
    }


    public class ClusterCaNestedImpl<N> extends CertificateAuthorityFluentImpl<KafkaSpecFluent.ClusterCaNested<N>> implements KafkaSpecFluent.ClusterCaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CertificateAuthorityBuilder builder;

            ClusterCaNestedImpl(CertificateAuthority item) {
                this.builder = new CertificateAuthorityBuilder(this, item);
                        
            }

            ClusterCaNestedImpl() {
                this.builder = new CertificateAuthorityBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withClusterCa(builder.build());
            }

            public N endClusterCa() {
                return and();
            }
    }


    public class JmxTransNestedImpl<N> extends JmxTransSpecFluentImpl<KafkaSpecFluent.JmxTransNested<N>> implements KafkaSpecFluent.JmxTransNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final JmxTransSpecBuilder builder;

            JmxTransNestedImpl(JmxTransSpec item) {
                this.builder = new JmxTransSpecBuilder(this, item);
                        
            }

            JmxTransNestedImpl() {
                this.builder = new JmxTransSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withJmxTrans(builder.build());
            }

            public N endJmxTrans() {
                return and();
            }
    }


    public class KafkaExporterNestedImpl<N> extends KafkaExporterSpecFluentImpl<KafkaSpecFluent.KafkaExporterNested<N>> implements KafkaSpecFluent.KafkaExporterNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaExporterSpecBuilder builder;

            KafkaExporterNestedImpl(KafkaExporterSpec item) {
                this.builder = new KafkaExporterSpecBuilder(this, item);
                        
            }

            KafkaExporterNestedImpl() {
                this.builder = new KafkaExporterSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withKafkaExporter(builder.build());
            }

            public N endKafkaExporter() {
                return and();
            }
    }


    public class CruiseControlNestedImpl<N> extends CruiseControlSpecFluentImpl<KafkaSpecFluent.CruiseControlNested<N>> implements KafkaSpecFluent.CruiseControlNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CruiseControlSpecBuilder builder;

            CruiseControlNestedImpl(CruiseControlSpec item) {
                this.builder = new CruiseControlSpecBuilder(this, item);
                        
            }

            CruiseControlNestedImpl() {
                this.builder = new CruiseControlSpecBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withCruiseControl(builder.build());
            }

            public N endCruiseControl() {
                return and();
            }
    }


    public class ClientsCaNestedImpl<N> extends CertificateAuthorityFluentImpl<KafkaSpecFluent.ClientsCaNested<N>> implements KafkaSpecFluent.ClientsCaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CertificateAuthorityBuilder builder;

            ClientsCaNestedImpl(CertificateAuthority item) {
                this.builder = new CertificateAuthorityBuilder(this, item);
                        
            }

            ClientsCaNestedImpl() {
                this.builder = new CertificateAuthorityBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaSpecFluentImpl.this.withClientsCa(builder.build());
            }

            public N endClientsCa() {
                return and();
            }
    }


}
