package io.strimzi.api.kafka.model;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface KafkaTopicSpecFluent<A extends KafkaTopicSpecFluent<A>> extends SpecFluent<A> {


    public String getTopicName();
    public A withTopicName(String topicName);
    public Boolean hasTopicName();
    public A withNewTopicName(StringBuilder arg1);
    public A withNewTopicName(int[] arg1,int arg2,int arg3);
    public A withNewTopicName(char[] arg1);
    public A withNewTopicName(StringBuffer arg1);
    public A withNewTopicName(byte[] arg1,int arg2);
    public A withNewTopicName(byte[] arg1);
    public A withNewTopicName(char[] arg1,int arg2,int arg3);
    public A withNewTopicName(byte[] arg1,int arg2,int arg3);
    public A withNewTopicName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewTopicName(String arg1);
    public Integer getPartitions();
    public A withPartitions(Integer partitions);
    public Boolean hasPartitions();
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A addToConfig(String key,Object value);
    public A addToConfig(Map<String,Object> map);
    public A removeFromConfig(String key);
    public A removeFromConfig(Map<String,Object> map);
    public Map<String,Object> getConfig();
    public <K extends Object,V extends Object>A withConfig(Map<String,Object> config);
    public Boolean hasConfig();
}
