package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaUserAuthorizationSimpleBuilder extends KafkaUserAuthorizationSimpleFluentImpl<KafkaUserAuthorizationSimpleBuilder> implements VisitableBuilder<KafkaUserAuthorizationSimple,KafkaUserAuthorizationSimpleBuilder> {

    KafkaUserAuthorizationSimpleFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaUserAuthorizationSimpleBuilder() {
        this(true);
    }

    public KafkaUserAuthorizationSimpleBuilder(Boolean validationEnabled) {
        this(new KafkaUserAuthorizationSimple(), validationEnabled);
    }

    public KafkaUserAuthorizationSimpleBuilder(KafkaUserAuthorizationSimpleFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaUserAuthorizationSimpleBuilder(KafkaUserAuthorizationSimpleFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaUserAuthorizationSimple(), validationEnabled);
    }

    public KafkaUserAuthorizationSimpleBuilder(KafkaUserAuthorizationSimpleFluent<?> fluent,KafkaUserAuthorizationSimple instance) {
        this(fluent, instance, true);
    }

    public KafkaUserAuthorizationSimpleBuilder(KafkaUserAuthorizationSimpleFluent<?> fluent,KafkaUserAuthorizationSimple instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAcls(instance.getAcls());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaUserAuthorizationSimpleBuilder(KafkaUserAuthorizationSimple instance) {
        this(instance,true);
    }

    public KafkaUserAuthorizationSimpleBuilder(KafkaUserAuthorizationSimple instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAcls(instance.getAcls());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaUserAuthorizationSimple build() {
        KafkaUserAuthorizationSimple buildable = new KafkaUserAuthorizationSimple();
        buildable.setAcls(fluent.getAcls());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaUserAuthorizationSimpleBuilder that = (KafkaUserAuthorizationSimpleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
