package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class KafkaUserAuthorizationSimpleFluentImpl<A extends KafkaUserAuthorizationSimpleFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaUserAuthorizationSimpleFluent<A> {

    private java.util.List<AclRuleBuilder> acls;

    public KafkaUserAuthorizationSimpleFluentImpl() {
    }

    public KafkaUserAuthorizationSimpleFluentImpl(KafkaUserAuthorizationSimple instance) {
        this.withAcls(instance.getAcls());
    }

    public A addToAcls(int index,AclRule item) {
        if (this.acls == null) {this.acls = new ArrayList<AclRuleBuilder>();}
        AclRuleBuilder builder = new AclRuleBuilder(item);_visitables.get("acls").add(index >= 0 ? index : _visitables.get("acls").size(), builder);this.acls.add(index >= 0 ? index : acls.size(), builder); return (A)this;
    }

    public A setToAcls(int index,AclRule item) {
        if (this.acls == null) {this.acls = new ArrayList<AclRuleBuilder>();}
        AclRuleBuilder builder = new AclRuleBuilder(item);
        if (index < 0 || index >= _visitables.get("acls").size()) { _visitables.get("acls").add(builder); } else { _visitables.get("acls").set(index, builder);}
        if (index < 0 || index >= acls.size()) { acls.add(builder); } else { acls.set(index, builder);}
         return (A)this;
    }

    public A addToAcls(AclRule... items) {
        if (this.acls == null) {this.acls = new ArrayList<AclRuleBuilder>();}
        for (AclRule item : items) {AclRuleBuilder builder = new AclRuleBuilder(item);_visitables.get("acls").add(builder);this.acls.add(builder);} return (A)this;
    }

    public A addAllToAcls(Collection<AclRule> items) {
        if (this.acls == null) {this.acls = new ArrayList<AclRuleBuilder>();}
        for (AclRule item : items) {AclRuleBuilder builder = new AclRuleBuilder(item);_visitables.get("acls").add(builder);this.acls.add(builder);} return (A)this;
    }

    public A removeFromAcls(AclRule... items) {
        for (AclRule item : items) {AclRuleBuilder builder = new AclRuleBuilder(item);_visitables.get("acls").remove(builder);if (this.acls != null) {this.acls.remove(builder);}} return (A)this;
    }

    public A removeAllFromAcls(Collection<AclRule> items) {
        for (AclRule item : items) {AclRuleBuilder builder = new AclRuleBuilder(item);_visitables.get("acls").remove(builder);if (this.acls != null) {this.acls.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromAcls(Predicate<AclRuleBuilder> predicate) {
        if (acls == null) return (A) this;
        final Iterator<AclRuleBuilder> each = acls.iterator();
        final List visitables = _visitables.get("acls");
        while (each.hasNext()) {
          AclRuleBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildAcls instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<AclRule> getAcls() {
        return build(acls);
    }

    public java.util.List<AclRule> buildAcls() {
        return build(acls);
    }

    public AclRule buildAcl(int index) {
        return this.acls.get(index).build();
    }

    public AclRule buildFirstAcl() {
        return this.acls.get(0).build();
    }

    public AclRule buildLastAcl() {
        return this.acls.get(acls.size() - 1).build();
    }

    public AclRule buildMatchingAcl(Predicate<AclRuleBuilder> predicate) {
        for (AclRuleBuilder item: acls) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingAcl(Predicate<AclRuleBuilder> predicate) {
        for (AclRuleBuilder item: acls) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAcls(java.util.List<AclRule> acls) {
        if (this.acls != null) { _visitables.get("acls").removeAll(this.acls);}
        if (acls != null) {this.acls = new ArrayList<AclRuleBuilder>(); for (AclRule item : acls){this.addToAcls(item);}} else { this.acls = null;} return (A) this;
    }

    public A withAcls(AclRule... acls) {
        if (this.acls != null) {this.acls.clear();}
        if (acls != null) {for (AclRule item :acls){ this.addToAcls(item);}} return (A) this;
    }

    public Boolean hasAcls() {
        return acls != null && !acls.isEmpty();
    }

    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> addNewAcl() {
        return new AclsNestedImpl();
    }

    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> addNewAclLike(AclRule item) {
        return new AclsNestedImpl(-1, item);
    }

    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> setNewAclLike(int index,AclRule item) {
        return new AclsNestedImpl(index, item);
    }

    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> editAcl(int index) {
        if (acls.size() <= index) throw new RuntimeException("Can't edit acls. Index exceeds size.");
        return setNewAclLike(index, buildAcl(index));
    }

    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> editFirstAcl() {
        if (acls.size() == 0) throw new RuntimeException("Can't edit first acls. The list is empty.");
        return setNewAclLike(0, buildAcl(0));
    }

    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> editLastAcl() {
        int index = acls.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last acls. The list is empty.");
        return setNewAclLike(index, buildAcl(index));
    }

    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> editMatchingAcl(Predicate<AclRuleBuilder> predicate) {
        int index = -1;
        for (int i=0;i<acls.size();i++) { 
        if (predicate.test(acls.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching acls. No match found.");
        return setNewAclLike(index, buildAcl(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaUserAuthorizationSimpleFluentImpl that = (KafkaUserAuthorizationSimpleFluentImpl) o;
        if (acls != null ? !acls.equals(that.acls) :that.acls != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(acls,  super.hashCode());
    }

    public class AclsNestedImpl<N> extends AclRuleFluentImpl<KafkaUserAuthorizationSimpleFluent.AclsNested<N>> implements KafkaUserAuthorizationSimpleFluent.AclsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AclRuleBuilder builder;
        private final int index;

            AclsNestedImpl(int index,AclRule item) {
                this.index = index;
                this.builder = new AclRuleBuilder(this, item);
                        
            }

            AclsNestedImpl() {
                this.index = -1;
                this.builder = new AclRuleBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaUserAuthorizationSimpleFluentImpl.this.setToAcls(index,builder.build());
            }

            public N endAcl() {
                return and();
            }
    }


}
