package io.strimzi.api.kafka.model;

import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaUserQuotasFluentImpl<A extends KafkaUserQuotasFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaUserQuotasFluent<A> {

    private Integer producerByteRate;
    private Integer consumerByteRate;
    private Integer requestPercentage;

    public KafkaUserQuotasFluentImpl() {
    }

    public KafkaUserQuotasFluentImpl(KafkaUserQuotas instance) {
        this.withProducerByteRate(instance.getProducerByteRate());
        
        this.withConsumerByteRate(instance.getConsumerByteRate());
        
        this.withRequestPercentage(instance.getRequestPercentage());
    }

    public Integer getProducerByteRate() {
        return this.producerByteRate;
    }

    public A withProducerByteRate(Integer producerByteRate) {
        this.producerByteRate=producerByteRate; return (A) this;
    }

    public Boolean hasProducerByteRate() {
        return this.producerByteRate != null;
    }

    public Integer getConsumerByteRate() {
        return this.consumerByteRate;
    }

    public A withConsumerByteRate(Integer consumerByteRate) {
        this.consumerByteRate=consumerByteRate; return (A) this;
    }

    public Boolean hasConsumerByteRate() {
        return this.consumerByteRate != null;
    }

    public Integer getRequestPercentage() {
        return this.requestPercentage;
    }

    public A withRequestPercentage(Integer requestPercentage) {
        this.requestPercentage=requestPercentage; return (A) this;
    }

    public Boolean hasRequestPercentage() {
        return this.requestPercentage != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaUserQuotasFluentImpl that = (KafkaUserQuotasFluentImpl) o;
        if (producerByteRate != null ? !producerByteRate.equals(that.producerByteRate) :that.producerByteRate != null) return false;
        if (consumerByteRate != null ? !consumerByteRate.equals(that.consumerByteRate) :that.consumerByteRate != null) return false;
        if (requestPercentage != null ? !requestPercentage.equals(that.requestPercentage) :that.requestPercentage != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(producerByteRate,  consumerByteRate,  requestPercentage,  super.hashCode());
    }

}
