package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PasswordSecretSourceBuilder extends PasswordSecretSourceFluentImpl<PasswordSecretSourceBuilder> implements VisitableBuilder<PasswordSecretSource,PasswordSecretSourceBuilder> {

    PasswordSecretSourceFluent<?> fluent;
    Boolean validationEnabled;

    public PasswordSecretSourceBuilder() {
        this(true);
    }

    public PasswordSecretSourceBuilder(Boolean validationEnabled) {
        this(new PasswordSecretSource(), validationEnabled);
    }

    public PasswordSecretSourceBuilder(PasswordSecretSourceFluent<?> fluent) {
        this(fluent, true);
    }

    public PasswordSecretSourceBuilder(PasswordSecretSourceFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new PasswordSecretSource(), validationEnabled);
    }

    public PasswordSecretSourceBuilder(PasswordSecretSourceFluent<?> fluent,PasswordSecretSource instance) {
        this(fluent, instance, true);
    }

    public PasswordSecretSourceBuilder(PasswordSecretSourceFluent<?> fluent,PasswordSecretSource instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSecretName(instance.getSecretName());
        
        fluent.withPassword(instance.getPassword());
        
        this.validationEnabled = validationEnabled; 
    }

    public PasswordSecretSourceBuilder(PasswordSecretSource instance) {
        this(instance,true);
    }

    public PasswordSecretSourceBuilder(PasswordSecretSource instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withSecretName(instance.getSecretName());
        
        this.withPassword(instance.getPassword());
        
        this.validationEnabled = validationEnabled; 
    }

    public PasswordSecretSource build() {
        PasswordSecretSource buildable = new PasswordSecretSource();
        buildable.setSecretName(fluent.getSecretName());
        buildable.setPassword(fluent.getPassword());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PasswordSecretSourceBuilder that = (PasswordSecretSourceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
