package io.strimzi.api.kafka.model;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class RackFluentImpl<A extends RackFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RackFluent<A> {

    private String topologyKey;

    public RackFluentImpl() {
    }

    public RackFluentImpl(Rack instance) {
        this.withTopologyKey(instance.getTopologyKey()); 
    }

    public String getTopologyKey() {
        return this.topologyKey;
    }

    public A withTopologyKey(String topologyKey) {
        this.topologyKey=topologyKey; return (A) this;
    }

    public Boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    public A withNewTopologyKey(StringBuilder arg1) {
        return (A)withTopologyKey(new String(arg1));
    }

    public A withNewTopologyKey(int[] arg1,int arg2,int arg3) {
        return (A)withTopologyKey(new String(arg1, arg2, arg3));
    }

    public A withNewTopologyKey(char[] arg1) {
        return (A)withTopologyKey(new String(arg1));
    }

    public A withNewTopologyKey(StringBuffer arg1) {
        return (A)withTopologyKey(new String(arg1));
    }

    public A withNewTopologyKey(byte[] arg1,int arg2) {
        return (A)withTopologyKey(new String(arg1, arg2));
    }

    public A withNewTopologyKey(byte[] arg1) {
        return (A)withTopologyKey(new String(arg1));
    }

    public A withNewTopologyKey(char[] arg1,int arg2,int arg3) {
        return (A)withTopologyKey(new String(arg1, arg2, arg3));
    }

    public A withNewTopologyKey(byte[] arg1,int arg2,int arg3) {
        return (A)withTopologyKey(new String(arg1, arg2, arg3));
    }

    public A withNewTopologyKey(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withTopologyKey(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewTopologyKey(String arg1) {
        return (A)withTopologyKey(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RackFluentImpl that = (RackFluentImpl) o;
        if (topologyKey != null ? !topologyKey.equals(that.topologyKey) :that.topologyKey != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(topologyKey,  super.hashCode());
    }

}
