package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SidecarBuilder extends SidecarFluentImpl<SidecarBuilder> implements VisitableBuilder<Sidecar,SidecarBuilder> {

    SidecarFluent<?> fluent;
    Boolean validationEnabled;

    public SidecarBuilder() {
        this(true);
    }

    public SidecarBuilder(Boolean validationEnabled) {
        this(new Sidecar(), validationEnabled);
    }

    public SidecarBuilder(SidecarFluent<?> fluent) {
        this(fluent, true);
    }

    public SidecarBuilder(SidecarFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Sidecar(), validationEnabled);
    }

    public SidecarBuilder(SidecarFluent<?> fluent,Sidecar instance) {
        this(fluent, instance, true);
    }

    public SidecarBuilder(SidecarFluent<?> fluent,Sidecar instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withImage(instance.getImage());
        
        fluent.withResources(instance.getResources());
        
        this.validationEnabled = validationEnabled; 
    }

    public SidecarBuilder(Sidecar instance) {
        this(instance,true);
    }

    public SidecarBuilder(Sidecar instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withImage(instance.getImage());
        
        this.withResources(instance.getResources());
        
        this.validationEnabled = validationEnabled; 
    }

    public Sidecar build() {
        Sidecar buildable = new Sidecar();
        buildable.setImage(fluent.getImage());
        buildable.setResources(fluent.getResources());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SidecarBuilder that = (SidecarBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
