package io.strimzi.api.kafka.model.authentication;

import io.strimzi.api.kafka.model.PasswordSecretSourceFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.PasswordSecretSource;
import java.lang.String;
import io.strimzi.api.kafka.model.PasswordSecretSourceBuilder;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaClientAuthenticationPlainFluentImpl<A extends KafkaClientAuthenticationPlainFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaClientAuthenticationPlainFluent<A> {

    private String username;
    private PasswordSecretSourceBuilder passwordSecret;

    public KafkaClientAuthenticationPlainFluentImpl() {
    }

    public KafkaClientAuthenticationPlainFluentImpl(KafkaClientAuthenticationPlain instance) {
        this.withUsername(instance.getUsername());
        
        this.withPasswordSecret(instance.getPasswordSecret());
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username=username; return (A) this;
    }

    public Boolean hasUsername() {
        return this.username != null;
    }

    public A withNewUsername(StringBuilder arg1) {
        return (A)withUsername(new String(arg1));
    }

    public A withNewUsername(int[] arg1,int arg2,int arg3) {
        return (A)withUsername(new String(arg1, arg2, arg3));
    }

    public A withNewUsername(char[] arg1) {
        return (A)withUsername(new String(arg1));
    }

    public A withNewUsername(StringBuffer arg1) {
        return (A)withUsername(new String(arg1));
    }

    public A withNewUsername(byte[] arg1,int arg2) {
        return (A)withUsername(new String(arg1, arg2));
    }

    public A withNewUsername(byte[] arg1) {
        return (A)withUsername(new String(arg1));
    }

    public A withNewUsername(char[] arg1,int arg2,int arg3) {
        return (A)withUsername(new String(arg1, arg2, arg3));
    }

    public A withNewUsername(byte[] arg1,int arg2,int arg3) {
        return (A)withUsername(new String(arg1, arg2, arg3));
    }

    public A withNewUsername(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUsername(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUsername(String arg1) {
        return (A)withUsername(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildPasswordSecret instead.
 * @return The buildable object.
 */
@Deprecated public PasswordSecretSource getPasswordSecret() {
        return this.passwordSecret!=null?this.passwordSecret.build():null;
    }

    public PasswordSecretSource buildPasswordSecret() {
        return this.passwordSecret!=null?this.passwordSecret.build():null;
    }

    public A withPasswordSecret(PasswordSecretSource passwordSecret) {
        _visitables.get("passwordSecret").remove(this.passwordSecret);
        if (passwordSecret!=null){ this.passwordSecret= new PasswordSecretSourceBuilder(passwordSecret); _visitables.get("passwordSecret").add(this.passwordSecret);} return (A) this;
    }

    public Boolean hasPasswordSecret() {
        return this.passwordSecret != null;
    }

    public KafkaClientAuthenticationPlainFluent.PasswordSecretNested<A> withNewPasswordSecret() {
        return new PasswordSecretNestedImpl();
    }

    public KafkaClientAuthenticationPlainFluent.PasswordSecretNested<A> withNewPasswordSecretLike(PasswordSecretSource item) {
        return new PasswordSecretNestedImpl(item);
    }

    public KafkaClientAuthenticationPlainFluent.PasswordSecretNested<A> editPasswordSecret() {
        return withNewPasswordSecretLike(getPasswordSecret());
    }

    public KafkaClientAuthenticationPlainFluent.PasswordSecretNested<A> editOrNewPasswordSecret() {
        return withNewPasswordSecretLike(getPasswordSecret() != null ? getPasswordSecret(): new PasswordSecretSourceBuilder().build());
    }

    public KafkaClientAuthenticationPlainFluent.PasswordSecretNested<A> editOrNewPasswordSecretLike(PasswordSecretSource item) {
        return withNewPasswordSecretLike(getPasswordSecret() != null ? getPasswordSecret(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaClientAuthenticationPlainFluentImpl that = (KafkaClientAuthenticationPlainFluentImpl) o;
        if (username != null ? !username.equals(that.username) :that.username != null) return false;
        if (passwordSecret != null ? !passwordSecret.equals(that.passwordSecret) :that.passwordSecret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(username,  passwordSecret,  super.hashCode());
    }

    public class PasswordSecretNestedImpl<N> extends PasswordSecretSourceFluentImpl<KafkaClientAuthenticationPlainFluent.PasswordSecretNested<N>> implements KafkaClientAuthenticationPlainFluent.PasswordSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PasswordSecretSourceBuilder builder;

            PasswordSecretNestedImpl(PasswordSecretSource item) {
                this.builder = new PasswordSecretSourceBuilder(this, item);
                        
            }

            PasswordSecretNestedImpl() {
                this.builder = new PasswordSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClientAuthenticationPlainFluentImpl.this.withPasswordSecret(builder.build());
            }

            public N endPasswordSecret() {
                return and();
            }
    }


}
