package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.CertAndKeySecretSourceBuilder;
import io.strimzi.api.kafka.model.CertAndKeySecretSourceFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.CertAndKeySecretSource;

public class KafkaClientAuthenticationTlsFluentImpl<A extends KafkaClientAuthenticationTlsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaClientAuthenticationTlsFluent<A> {

    private CertAndKeySecretSourceBuilder certificateAndKey;

    public KafkaClientAuthenticationTlsFluentImpl() {
    }

    public KafkaClientAuthenticationTlsFluentImpl(KafkaClientAuthenticationTls instance) {
        this.withCertificateAndKey(instance.getCertificateAndKey());
    }

    
/**
 * This method has been deprecated, please use method buildCertificateAndKey instead.
 * @return The buildable object.
 */
@Deprecated public CertAndKeySecretSource getCertificateAndKey() {
        return this.certificateAndKey!=null?this.certificateAndKey.build():null;
    }

    public CertAndKeySecretSource buildCertificateAndKey() {
        return this.certificateAndKey!=null?this.certificateAndKey.build():null;
    }

    public A withCertificateAndKey(CertAndKeySecretSource certificateAndKey) {
        _visitables.get("certificateAndKey").remove(this.certificateAndKey);
        if (certificateAndKey!=null){ this.certificateAndKey= new CertAndKeySecretSourceBuilder(certificateAndKey); _visitables.get("certificateAndKey").add(this.certificateAndKey);} return (A) this;
    }

    public Boolean hasCertificateAndKey() {
        return this.certificateAndKey != null;
    }

    public KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<A> withNewCertificateAndKey() {
        return new CertificateAndKeyNestedImpl();
    }

    public KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<A> withNewCertificateAndKeyLike(CertAndKeySecretSource item) {
        return new CertificateAndKeyNestedImpl(item);
    }

    public KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<A> editCertificateAndKey() {
        return withNewCertificateAndKeyLike(getCertificateAndKey());
    }

    public KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<A> editOrNewCertificateAndKey() {
        return withNewCertificateAndKeyLike(getCertificateAndKey() != null ? getCertificateAndKey(): new CertAndKeySecretSourceBuilder().build());
    }

    public KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<A> editOrNewCertificateAndKeyLike(CertAndKeySecretSource item) {
        return withNewCertificateAndKeyLike(getCertificateAndKey() != null ? getCertificateAndKey(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaClientAuthenticationTlsFluentImpl that = (KafkaClientAuthenticationTlsFluentImpl) o;
        if (certificateAndKey != null ? !certificateAndKey.equals(that.certificateAndKey) :that.certificateAndKey != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(certificateAndKey,  super.hashCode());
    }

    public class CertificateAndKeyNestedImpl<N> extends CertAndKeySecretSourceFluentImpl<KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<N>> implements KafkaClientAuthenticationTlsFluent.CertificateAndKeyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CertAndKeySecretSourceBuilder builder;

            CertificateAndKeyNestedImpl(CertAndKeySecretSource item) {
                this.builder = new CertAndKeySecretSourceBuilder(this, item);
                        
            }

            CertificateAndKeyNestedImpl() {
                this.builder = new CertAndKeySecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClientAuthenticationTlsFluentImpl.this.withCertificateAndKey(builder.build());
            }

            public N endCertificateAndKey() {
                return and();
            }
    }


}
