package io.strimzi.api.kafka.model.balancing;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BrokerCapacityBuilder extends BrokerCapacityFluentImpl<BrokerCapacityBuilder> implements VisitableBuilder<BrokerCapacity,BrokerCapacityBuilder> {

    BrokerCapacityFluent<?> fluent;
    Boolean validationEnabled;

    public BrokerCapacityBuilder() {
        this(true);
    }

    public BrokerCapacityBuilder(Boolean validationEnabled) {
        this(new BrokerCapacity(), validationEnabled);
    }

    public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent) {
        this(fluent, true);
    }

    public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new BrokerCapacity(), validationEnabled);
    }

    public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent,BrokerCapacity instance) {
        this(fluent, instance, true);
    }

    public BrokerCapacityBuilder(BrokerCapacityFluent<?> fluent,BrokerCapacity instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDisk(instance.getDisk());
        
        fluent.withCpuUtilization(instance.getCpuUtilization());
        
        fluent.withInboundNetwork(instance.getInboundNetwork());
        
        fluent.withOutboundNetwork(instance.getOutboundNetwork());
        
        this.validationEnabled = validationEnabled; 
    }

    public BrokerCapacityBuilder(BrokerCapacity instance) {
        this(instance,true);
    }

    public BrokerCapacityBuilder(BrokerCapacity instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDisk(instance.getDisk());
        
        this.withCpuUtilization(instance.getCpuUtilization());
        
        this.withInboundNetwork(instance.getInboundNetwork());
        
        this.withOutboundNetwork(instance.getOutboundNetwork());
        
        this.validationEnabled = validationEnabled; 
    }

    public BrokerCapacity build() {
        BrokerCapacity buildable = new BrokerCapacity();
        buildable.setDisk(fluent.getDisk());
        buildable.setCpuUtilization(fluent.getCpuUtilization());
        buildable.setInboundNetwork(fluent.getInboundNetwork());
        buildable.setOutboundNetwork(fluent.getOutboundNetwork());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BrokerCapacityBuilder that = (BrokerCapacityBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
