package io.strimzi.api.kafka.model.connect;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ConnectorPluginFluentImpl<A extends ConnectorPluginFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ConnectorPluginFluent<A> {

    private String connectorClass;
    private String type;
    private String version;

    public ConnectorPluginFluentImpl() {
    }

    public ConnectorPluginFluentImpl(ConnectorPlugin instance) {
        this.withConnectorClass(instance.getConnectorClass());
        
        this.withType(instance.getType());
        
        this.withVersion(instance.getVersion());
    }

    public String getConnectorClass() {
        return this.connectorClass;
    }

    public A withConnectorClass(String connectorClass) {
        this.connectorClass=connectorClass; return (A) this;
    }

    public Boolean hasConnectorClass() {
        return this.connectorClass != null;
    }

    public A withNewConnectorClass(StringBuilder arg1) {
        return (A)withConnectorClass(new String(arg1));
    }

    public A withNewConnectorClass(int[] arg1,int arg2,int arg3) {
        return (A)withConnectorClass(new String(arg1, arg2, arg3));
    }

    public A withNewConnectorClass(char[] arg1) {
        return (A)withConnectorClass(new String(arg1));
    }

    public A withNewConnectorClass(StringBuffer arg1) {
        return (A)withConnectorClass(new String(arg1));
    }

    public A withNewConnectorClass(byte[] arg1,int arg2) {
        return (A)withConnectorClass(new String(arg1, arg2));
    }

    public A withNewConnectorClass(byte[] arg1) {
        return (A)withConnectorClass(new String(arg1));
    }

    public A withNewConnectorClass(char[] arg1,int arg2,int arg3) {
        return (A)withConnectorClass(new String(arg1, arg2, arg3));
    }

    public A withNewConnectorClass(byte[] arg1,int arg2,int arg3) {
        return (A)withConnectorClass(new String(arg1, arg2, arg3));
    }

    public A withNewConnectorClass(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withConnectorClass(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewConnectorClass(String arg1) {
        return (A)withConnectorClass(new String(arg1));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public A withNewType(StringBuilder arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(int[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(char[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(StringBuffer arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(byte[] arg1,int arg2) {
        return (A)withType(new String(arg1, arg2));
    }

    public A withNewType(byte[] arg1) {
        return (A)withType(new String(arg1));
    }

    public A withNewType(char[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3) {
        return (A)withType(new String(arg1, arg2, arg3));
    }

    public A withNewType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewType(String arg1) {
        return (A)withType(new String(arg1));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(int[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(char[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(byte[] arg1,int arg2) {
        return (A)withVersion(new String(arg1, arg2));
    }

    public A withNewVersion(byte[] arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(char[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withVersion(new String(arg1, arg2, arg3));
    }

    public A withNewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ConnectorPluginFluentImpl that = (ConnectorPluginFluentImpl) o;
        if (connectorClass != null ? !connectorClass.equals(that.connectorClass) :that.connectorClass != null) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(connectorClass,  type,  version,  super.hashCode());
    }

}
