package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ExternalConfigurationFluent<A extends ExternalConfigurationFluent<A>> extends Fluent<A> {


    public A addToEnv(int index,ExternalConfigurationEnv item);
    public A setToEnv(int index,ExternalConfigurationEnv item);
    public A addToEnv(ExternalConfigurationEnv... items);
    public A addAllToEnv(Collection<ExternalConfigurationEnv> items);
    public A removeFromEnv(ExternalConfigurationEnv... items);
    public A removeAllFromEnv(Collection<ExternalConfigurationEnv> items);
    public A removeMatchingFromEnv(Predicate<ExternalConfigurationEnvBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildEnv instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<ExternalConfigurationEnv> getEnv();
    public java.util.List<ExternalConfigurationEnv> buildEnv();
    public ExternalConfigurationEnv buildEnv(int index);
    public ExternalConfigurationEnv buildFirstEnv();
    public ExternalConfigurationEnv buildLastEnv();
    public ExternalConfigurationEnv buildMatchingEnv(Predicate<ExternalConfigurationEnvBuilder> predicate);
    public Boolean hasMatchingEnv(Predicate<ExternalConfigurationEnvBuilder> predicate);
    public A withEnv(java.util.List<ExternalConfigurationEnv> env);
    public A withEnv(ExternalConfigurationEnv... env);
    public Boolean hasEnv();
    public ExternalConfigurationFluent.EnvNested<A> addNewEnv();
    public ExternalConfigurationFluent.EnvNested<A> addNewEnvLike(ExternalConfigurationEnv item);
    public ExternalConfigurationFluent.EnvNested<A> setNewEnvLike(int index,ExternalConfigurationEnv item);
    public ExternalConfigurationFluent.EnvNested<A> editEnv(int index);
    public ExternalConfigurationFluent.EnvNested<A> editFirstEnv();
    public ExternalConfigurationFluent.EnvNested<A> editLastEnv();
    public ExternalConfigurationFluent.EnvNested<A> editMatchingEnv(Predicate<ExternalConfigurationEnvBuilder> predicate);
    public A addToVolumes(int index,ExternalConfigurationVolumeSource item);
    public A setToVolumes(int index,ExternalConfigurationVolumeSource item);
    public A addToVolumes(ExternalConfigurationVolumeSource... items);
    public A addAllToVolumes(Collection<ExternalConfigurationVolumeSource> items);
    public A removeFromVolumes(ExternalConfigurationVolumeSource... items);
    public A removeAllFromVolumes(Collection<ExternalConfigurationVolumeSource> items);
    public A removeMatchingFromVolumes(Predicate<ExternalConfigurationVolumeSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<ExternalConfigurationVolumeSource> getVolumes();
    public java.util.List<ExternalConfigurationVolumeSource> buildVolumes();
    public ExternalConfigurationVolumeSource buildVolume(int index);
    public ExternalConfigurationVolumeSource buildFirstVolume();
    public ExternalConfigurationVolumeSource buildLastVolume();
    public ExternalConfigurationVolumeSource buildMatchingVolume(Predicate<ExternalConfigurationVolumeSourceBuilder> predicate);
    public Boolean hasMatchingVolume(Predicate<ExternalConfigurationVolumeSourceBuilder> predicate);
    public A withVolumes(java.util.List<ExternalConfigurationVolumeSource> volumes);
    public A withVolumes(ExternalConfigurationVolumeSource... volumes);
    public Boolean hasVolumes();
    public ExternalConfigurationFluent.VolumesNested<A> addNewVolume();
    public ExternalConfigurationFluent.VolumesNested<A> addNewVolumeLike(ExternalConfigurationVolumeSource item);
    public ExternalConfigurationFluent.VolumesNested<A> setNewVolumeLike(int index,ExternalConfigurationVolumeSource item);
    public ExternalConfigurationFluent.VolumesNested<A> editVolume(int index);
    public ExternalConfigurationFluent.VolumesNested<A> editFirstVolume();
    public ExternalConfigurationFluent.VolumesNested<A> editLastVolume();
    public ExternalConfigurationFluent.VolumesNested<A> editMatchingVolume(Predicate<ExternalConfigurationVolumeSourceBuilder> predicate);
    public interface EnvNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ExternalConfigurationEnvFluent<ExternalConfigurationFluent.EnvNested<N>> {

            public N and();
            public N endEnv();    }


    public interface VolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ExternalConfigurationVolumeSourceFluent<ExternalConfigurationFluent.VolumesNested<N>> {

            public N and();
            public N endVolume();    }


}
