package io.strimzi.api.kafka.model.connect.build;

import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class DockerOutputFluentImpl<A extends DockerOutputFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DockerOutputFluent<A> {

    private String image;
    private String pushSecret;
    private java.util.List<String> additionalKanikoOptions;

    public DockerOutputFluentImpl() {
    }

    public DockerOutputFluentImpl(DockerOutput instance) {
        this.withImage(instance.getImage());
        
        this.withPushSecret(instance.getPushSecret());
        
        this.withAdditionalKanikoOptions(instance.getAdditionalKanikoOptions());
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(int[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(char[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(byte[] arg1,int arg2) {
        return (A)withImage(new String(arg1, arg2));
    }

    public A withNewImage(byte[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(char[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public String getPushSecret() {
        return this.pushSecret;
    }

    public A withPushSecret(String pushSecret) {
        this.pushSecret=pushSecret; return (A) this;
    }

    public Boolean hasPushSecret() {
        return this.pushSecret != null;
    }

    public A withNewPushSecret(StringBuilder arg1) {
        return (A)withPushSecret(new String(arg1));
    }

    public A withNewPushSecret(int[] arg1,int arg2,int arg3) {
        return (A)withPushSecret(new String(arg1, arg2, arg3));
    }

    public A withNewPushSecret(char[] arg1) {
        return (A)withPushSecret(new String(arg1));
    }

    public A withNewPushSecret(StringBuffer arg1) {
        return (A)withPushSecret(new String(arg1));
    }

    public A withNewPushSecret(byte[] arg1,int arg2) {
        return (A)withPushSecret(new String(arg1, arg2));
    }

    public A withNewPushSecret(byte[] arg1) {
        return (A)withPushSecret(new String(arg1));
    }

    public A withNewPushSecret(char[] arg1,int arg2,int arg3) {
        return (A)withPushSecret(new String(arg1, arg2, arg3));
    }

    public A withNewPushSecret(byte[] arg1,int arg2,int arg3) {
        return (A)withPushSecret(new String(arg1, arg2, arg3));
    }

    public A withNewPushSecret(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withPushSecret(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewPushSecret(String arg1) {
        return (A)withPushSecret(new String(arg1));
    }

    public A addToAdditionalKanikoOptions(int index,String item) {
        if (this.additionalKanikoOptions == null) {this.additionalKanikoOptions = new ArrayList<String>();}
        this.additionalKanikoOptions.add(index, item);
        return (A)this;
    }

    public A setToAdditionalKanikoOptions(int index,String item) {
        if (this.additionalKanikoOptions == null) {this.additionalKanikoOptions = new ArrayList<String>();}
        this.additionalKanikoOptions.set(index, item); return (A)this;
    }

    public A addToAdditionalKanikoOptions(String... items) {
        if (this.additionalKanikoOptions == null) {this.additionalKanikoOptions = new ArrayList<String>();}
        for (String item : items) {this.additionalKanikoOptions.add(item);} return (A)this;
    }

    public A addAllToAdditionalKanikoOptions(Collection<String> items) {
        if (this.additionalKanikoOptions == null) {this.additionalKanikoOptions = new ArrayList<String>();}
        for (String item : items) {this.additionalKanikoOptions.add(item);} return (A)this;
    }

    public A removeFromAdditionalKanikoOptions(String... items) {
        for (String item : items) {if (this.additionalKanikoOptions!= null){ this.additionalKanikoOptions.remove(item);}} return (A)this;
    }

    public A removeAllFromAdditionalKanikoOptions(Collection<String> items) {
        for (String item : items) {if (this.additionalKanikoOptions!= null){ this.additionalKanikoOptions.remove(item);}} return (A)this;
    }

    public java.util.List<String> getAdditionalKanikoOptions() {
        return this.additionalKanikoOptions;
    }

    public String getAdditionalKanikoOption(int index) {
        return this.additionalKanikoOptions.get(index);
    }

    public String getFirstAdditionalKanikoOption() {
        return this.additionalKanikoOptions.get(0);
    }

    public String getLastAdditionalKanikoOption() {
        return this.additionalKanikoOptions.get(additionalKanikoOptions.size() - 1);
    }

    public String getMatchingAdditionalKanikoOption(Predicate<String> predicate) {
        for (String item: additionalKanikoOptions) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAdditionalKanikoOption(Predicate<String> predicate) {
        for (String item: additionalKanikoOptions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAdditionalKanikoOptions(java.util.List<String> additionalKanikoOptions) {
        if (this.additionalKanikoOptions != null) { _visitables.get("additionalKanikoOptions").removeAll(this.additionalKanikoOptions);}
        if (additionalKanikoOptions != null) {this.additionalKanikoOptions = new ArrayList<String>(); for (String item : additionalKanikoOptions){this.addToAdditionalKanikoOptions(item);}} else { this.additionalKanikoOptions = null;} return (A) this;
    }

    public A withAdditionalKanikoOptions(String... additionalKanikoOptions) {
        if (this.additionalKanikoOptions != null) {this.additionalKanikoOptions.clear();}
        if (additionalKanikoOptions != null) {for (String item :additionalKanikoOptions){ this.addToAdditionalKanikoOptions(item);}} return (A) this;
    }

    public Boolean hasAdditionalKanikoOptions() {
        return additionalKanikoOptions != null && !additionalKanikoOptions.isEmpty();
    }

    public A addNewAdditionalKanikoOption(StringBuilder arg1) {
        return (A)addToAdditionalKanikoOptions(new String(arg1));
    }

    public A addNewAdditionalKanikoOption(int[] arg1,int arg2,int arg3) {
        return (A)addToAdditionalKanikoOptions(new String(arg1, arg2, arg3));
    }

    public A addNewAdditionalKanikoOption(char[] arg1) {
        return (A)addToAdditionalKanikoOptions(new String(arg1));
    }

    public A addNewAdditionalKanikoOption(StringBuffer arg1) {
        return (A)addToAdditionalKanikoOptions(new String(arg1));
    }

    public A addNewAdditionalKanikoOption(byte[] arg1,int arg2) {
        return (A)addToAdditionalKanikoOptions(new String(arg1, arg2));
    }

    public A addNewAdditionalKanikoOption(byte[] arg1) {
        return (A)addToAdditionalKanikoOptions(new String(arg1));
    }

    public A addNewAdditionalKanikoOption(char[] arg1,int arg2,int arg3) {
        return (A)addToAdditionalKanikoOptions(new String(arg1, arg2, arg3));
    }

    public A addNewAdditionalKanikoOption(byte[] arg1,int arg2,int arg3) {
        return (A)addToAdditionalKanikoOptions(new String(arg1, arg2, arg3));
    }

    public A addNewAdditionalKanikoOption(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToAdditionalKanikoOptions(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewAdditionalKanikoOption(String arg1) {
        return (A)addToAdditionalKanikoOptions(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DockerOutputFluentImpl that = (DockerOutputFluentImpl) o;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (pushSecret != null ? !pushSecret.equals(that.pushSecret) :that.pushSecret != null) return false;
        if (additionalKanikoOptions != null ? !additionalKanikoOptions.equals(that.additionalKanikoOptions) :that.additionalKanikoOptions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(image,  pushSecret,  additionalKanikoOptions,  super.hashCode());
    }

}
