package io.strimzi.api.kafka.model.listener;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class IngressListenerBootstrapConfigurationFluentImpl<A extends IngressListenerBootstrapConfigurationFluent<A>> extends ExternalListenerBootstrapOverrideFluentImpl<A> implements IngressListenerBootstrapConfigurationFluent<A> {

    private String host;
    private Map<String,String> dnsAnnotations;

    public IngressListenerBootstrapConfigurationFluentImpl() {
    }

    public IngressListenerBootstrapConfigurationFluentImpl(IngressListenerBootstrapConfiguration instance) {
        this.withHost(instance.getHost());
        
        this.withDnsAnnotations(instance.getDnsAnnotations());
        
        this.withAddress(instance.getAddress());
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host=host; return (A) this;
    }

    public Boolean hasHost() {
        return this.host != null;
    }

    public A withNewHost(StringBuilder arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(int[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(char[] arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(byte[] arg1,int arg2) {
        return (A)withHost(new String(arg1, arg2));
    }

    public A withNewHost(byte[] arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(char[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(byte[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withHost(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewHost(String arg1) {
        return (A)withHost(new String(arg1));
    }

    public A addToDnsAnnotations(String key,String value) {
        if(this.dnsAnnotations == null && key != null && value != null) { this.dnsAnnotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.dnsAnnotations.put(key, value);} return (A)this;
    }

    public A addToDnsAnnotations(Map<String,String> map) {
        if(this.dnsAnnotations == null && map != null) { this.dnsAnnotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.dnsAnnotations.putAll(map);} return (A)this;
    }

    public A removeFromDnsAnnotations(String key) {
        if(this.dnsAnnotations == null) { return (A) this; }
        if(key != null && this.dnsAnnotations != null) {this.dnsAnnotations.remove(key);} return (A)this;
    }

    public A removeFromDnsAnnotations(Map<String,String> map) {
        if(this.dnsAnnotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.dnsAnnotations != null){this.dnsAnnotations.remove(key);}}} return (A)this;
    }

    public Map<String,String> getDnsAnnotations() {
        return this.dnsAnnotations;
    }

    public <K extends Object,V extends Object>A withDnsAnnotations(Map<String,String> dnsAnnotations) {
        if (dnsAnnotations == null) { this.dnsAnnotations =  null;} else {this.dnsAnnotations = new LinkedHashMap<String,String>(dnsAnnotations);} return (A) this;
    }

    public Boolean hasDnsAnnotations() {
        return this.dnsAnnotations != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressListenerBootstrapConfigurationFluentImpl that = (IngressListenerBootstrapConfigurationFluentImpl) o;
        if (host != null ? !host.equals(that.host) :that.host != null) return false;
        if (dnsAnnotations != null ? !dnsAnnotations.equals(that.dnsAnnotations) :that.dnsAnnotations != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(host,  dnsAnnotations,  super.hashCode());
    }

}
