package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressListenerConfigurationBuilder extends IngressListenerConfigurationFluentImpl<IngressListenerConfigurationBuilder> implements VisitableBuilder<IngressListenerConfiguration,IngressListenerConfigurationBuilder> {

    IngressListenerConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public IngressListenerConfigurationBuilder() {
        this(true);
    }

    public IngressListenerConfigurationBuilder(Boolean validationEnabled) {
        this(new IngressListenerConfiguration(), validationEnabled);
    }

    public IngressListenerConfigurationBuilder(IngressListenerConfigurationFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressListenerConfigurationBuilder(IngressListenerConfigurationFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IngressListenerConfiguration(), validationEnabled);
    }

    public IngressListenerConfigurationBuilder(IngressListenerConfigurationFluent<?> fluent,IngressListenerConfiguration instance) {
        this(fluent, instance, true);
    }

    public IngressListenerConfigurationBuilder(IngressListenerConfigurationFluent<?> fluent,IngressListenerConfiguration instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBootstrap(instance.getBootstrap());
        
        fluent.withBrokers(instance.getBrokers());
        
        fluent.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
        
        this.validationEnabled = validationEnabled; 
    }

    public IngressListenerConfigurationBuilder(IngressListenerConfiguration instance) {
        this(instance,true);
    }

    public IngressListenerConfigurationBuilder(IngressListenerConfiguration instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBootstrap(instance.getBootstrap());
        
        this.withBrokers(instance.getBrokers());
        
        this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());
        
        this.validationEnabled = validationEnabled; 
    }

    public IngressListenerConfiguration build() {
        IngressListenerConfiguration buildable = new IngressListenerConfiguration();
        buildable.setBrokerCertChainAndKey(fluent.getBrokerCertChainAndKey());
        buildable.setBootstrap(fluent.getBootstrap());
        buildable.setBrokers(fluent.getBrokers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressListenerConfigurationBuilder that = (IngressListenerConfigurationBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
