package io.strimzi.api.kafka.model.listener;

import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.CertSecretSource;

public class KafkaListenerAuthenticationOAuthFluentImpl<A extends KafkaListenerAuthenticationOAuthFluent<A>> extends KafkaListenerAuthenticationFluentImpl<A> implements KafkaListenerAuthenticationOAuthFluent<A> {

    private String clientId;
    private GenericSecretSourceBuilder clientSecret;
    private String validIssuerUri;
    private boolean checkIssuer;
    private boolean checkAudience;
    private String jwksEndpointUri;
    private Integer jwksRefreshSeconds;
    private Integer jwksMinRefreshPauseSeconds;
    private Integer jwksExpirySeconds;
    private String introspectionEndpointUri;
    private String userNameClaim;
    private String fallbackUserNameClaim;
    private String fallbackUserNamePrefix;
    private String userInfoEndpointUri;
    private boolean checkAccessTokenType;
    private String validTokenType;
    private boolean accessTokenIsJwt;
    private java.util.List<CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;
    private boolean enableECDSA;
    private Integer maxSecondsWithoutReauthentication;
    private boolean enablePlain;
    private String tokenEndpointUri;
    private boolean enableOauthBearer;
    private String customClaimCheck;

    public KafkaListenerAuthenticationOAuthFluentImpl() {
    }

    public KafkaListenerAuthenticationOAuthFluentImpl(KafkaListenerAuthenticationOAuth instance) {
        this.withClientId(instance.getClientId());
        
        this.withClientSecret(instance.getClientSecret());
        
        this.withValidIssuerUri(instance.getValidIssuerUri());
        
        this.withCheckIssuer(instance.isCheckIssuer());
        
        this.withCheckAudience(instance.isCheckAudience());
        
        this.withJwksEndpointUri(instance.getJwksEndpointUri());
        
        this.withJwksRefreshSeconds(instance.getJwksRefreshSeconds());
        
        this.withJwksMinRefreshPauseSeconds(instance.getJwksMinRefreshPauseSeconds());
        
        this.withJwksExpirySeconds(instance.getJwksExpirySeconds());
        
        this.withIntrospectionEndpointUri(instance.getIntrospectionEndpointUri());
        
        this.withUserNameClaim(instance.getUserNameClaim());
        
        this.withFallbackUserNameClaim(instance.getFallbackUserNameClaim());
        
        this.withFallbackUserNamePrefix(instance.getFallbackUserNamePrefix());
        
        this.withUserInfoEndpointUri(instance.getUserInfoEndpointUri());
        
        this.withCheckAccessTokenType(instance.isCheckAccessTokenType());
        
        this.withValidTokenType(instance.getValidTokenType());
        
        this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
        
        this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        
        this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        
        this.withEnableECDSA(instance.isEnableECDSA());
        
        this.withMaxSecondsWithoutReauthentication(instance.getMaxSecondsWithoutReauthentication());
        
        this.withEnablePlain(instance.isEnablePlain());
        
        this.withTokenEndpointUri(instance.getTokenEndpointUri());
        
        this.withEnableOauthBearer(instance.isEnableOauthBearer());
        
        this.withCustomClaimCheck(instance.getCustomClaimCheck());
    }

    public String getClientId() {
        return this.clientId;
    }

    public A withClientId(String clientId) {
        this.clientId=clientId; return (A) this;
    }

    public Boolean hasClientId() {
        return this.clientId != null;
    }

    public A withNewClientId(StringBuilder arg1) {
        return (A)withClientId(new String(arg1));
    }

    public A withNewClientId(int[] arg1,int arg2,int arg3) {
        return (A)withClientId(new String(arg1, arg2, arg3));
    }

    public A withNewClientId(char[] arg1) {
        return (A)withClientId(new String(arg1));
    }

    public A withNewClientId(StringBuffer arg1) {
        return (A)withClientId(new String(arg1));
    }

    public A withNewClientId(byte[] arg1,int arg2) {
        return (A)withClientId(new String(arg1, arg2));
    }

    public A withNewClientId(byte[] arg1) {
        return (A)withClientId(new String(arg1));
    }

    public A withNewClientId(char[] arg1,int arg2,int arg3) {
        return (A)withClientId(new String(arg1, arg2, arg3));
    }

    public A withNewClientId(byte[] arg1,int arg2,int arg3) {
        return (A)withClientId(new String(arg1, arg2, arg3));
    }

    public A withNewClientId(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withClientId(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewClientId(String arg1) {
        return (A)withClientId(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildClientSecret instead.
 * @return The buildable object.
 */
@Deprecated public GenericSecretSource getClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public GenericSecretSource buildClientSecret() {
        return this.clientSecret!=null?this.clientSecret.build():null;
    }

    public A withClientSecret(GenericSecretSource clientSecret) {
        _visitables.get("clientSecret").remove(this.clientSecret);
        if (clientSecret!=null){ this.clientSecret= new GenericSecretSourceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
    }

    public Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNestedImpl();
    }

    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecretLike(GenericSecretSource item) {
        return new ClientSecretNestedImpl(item);
    }

    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editClientSecret() {
        return withNewClientSecretLike(getClientSecret());
    }

    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new GenericSecretSourceBuilder().build());
    }

    public KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecretLike(GenericSecretSource item) {
        return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
    }

    public String getValidIssuerUri() {
        return this.validIssuerUri;
    }

    public A withValidIssuerUri(String validIssuerUri) {
        this.validIssuerUri=validIssuerUri; return (A) this;
    }

    public Boolean hasValidIssuerUri() {
        return this.validIssuerUri != null;
    }

    public A withNewValidIssuerUri(StringBuilder arg1) {
        return (A)withValidIssuerUri(new String(arg1));
    }

    public A withNewValidIssuerUri(int[] arg1,int arg2,int arg3) {
        return (A)withValidIssuerUri(new String(arg1, arg2, arg3));
    }

    public A withNewValidIssuerUri(char[] arg1) {
        return (A)withValidIssuerUri(new String(arg1));
    }

    public A withNewValidIssuerUri(StringBuffer arg1) {
        return (A)withValidIssuerUri(new String(arg1));
    }

    public A withNewValidIssuerUri(byte[] arg1,int arg2) {
        return (A)withValidIssuerUri(new String(arg1, arg2));
    }

    public A withNewValidIssuerUri(byte[] arg1) {
        return (A)withValidIssuerUri(new String(arg1));
    }

    public A withNewValidIssuerUri(char[] arg1,int arg2,int arg3) {
        return (A)withValidIssuerUri(new String(arg1, arg2, arg3));
    }

    public A withNewValidIssuerUri(byte[] arg1,int arg2,int arg3) {
        return (A)withValidIssuerUri(new String(arg1, arg2, arg3));
    }

    public A withNewValidIssuerUri(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withValidIssuerUri(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewValidIssuerUri(String arg1) {
        return (A)withValidIssuerUri(new String(arg1));
    }

    public boolean isCheckIssuer() {
        return this.checkIssuer;
    }

    public A withCheckIssuer(boolean checkIssuer) {
        this.checkIssuer=checkIssuer; return (A) this;
    }

    public Boolean hasCheckIssuer() {
        return true;
    }

    public boolean isCheckAudience() {
        return this.checkAudience;
    }

    public A withCheckAudience(boolean checkAudience) {
        this.checkAudience=checkAudience; return (A) this;
    }

    public Boolean hasCheckAudience() {
        return true;
    }

    public String getJwksEndpointUri() {
        return this.jwksEndpointUri;
    }

    public A withJwksEndpointUri(String jwksEndpointUri) {
        this.jwksEndpointUri=jwksEndpointUri; return (A) this;
    }

    public Boolean hasJwksEndpointUri() {
        return this.jwksEndpointUri != null;
    }

    public A withNewJwksEndpointUri(StringBuilder arg1) {
        return (A)withJwksEndpointUri(new String(arg1));
    }

    public A withNewJwksEndpointUri(int[] arg1,int arg2,int arg3) {
        return (A)withJwksEndpointUri(new String(arg1, arg2, arg3));
    }

    public A withNewJwksEndpointUri(char[] arg1) {
        return (A)withJwksEndpointUri(new String(arg1));
    }

    public A withNewJwksEndpointUri(StringBuffer arg1) {
        return (A)withJwksEndpointUri(new String(arg1));
    }

    public A withNewJwksEndpointUri(byte[] arg1,int arg2) {
        return (A)withJwksEndpointUri(new String(arg1, arg2));
    }

    public A withNewJwksEndpointUri(byte[] arg1) {
        return (A)withJwksEndpointUri(new String(arg1));
    }

    public A withNewJwksEndpointUri(char[] arg1,int arg2,int arg3) {
        return (A)withJwksEndpointUri(new String(arg1, arg2, arg3));
    }

    public A withNewJwksEndpointUri(byte[] arg1,int arg2,int arg3) {
        return (A)withJwksEndpointUri(new String(arg1, arg2, arg3));
    }

    public A withNewJwksEndpointUri(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withJwksEndpointUri(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewJwksEndpointUri(String arg1) {
        return (A)withJwksEndpointUri(new String(arg1));
    }

    public Integer getJwksRefreshSeconds() {
        return this.jwksRefreshSeconds;
    }

    public A withJwksRefreshSeconds(Integer jwksRefreshSeconds) {
        this.jwksRefreshSeconds=jwksRefreshSeconds; return (A) this;
    }

    public Boolean hasJwksRefreshSeconds() {
        return this.jwksRefreshSeconds != null;
    }

    public Integer getJwksMinRefreshPauseSeconds() {
        return this.jwksMinRefreshPauseSeconds;
    }

    public A withJwksMinRefreshPauseSeconds(Integer jwksMinRefreshPauseSeconds) {
        this.jwksMinRefreshPauseSeconds=jwksMinRefreshPauseSeconds; return (A) this;
    }

    public Boolean hasJwksMinRefreshPauseSeconds() {
        return this.jwksMinRefreshPauseSeconds != null;
    }

    public Integer getJwksExpirySeconds() {
        return this.jwksExpirySeconds;
    }

    public A withJwksExpirySeconds(Integer jwksExpirySeconds) {
        this.jwksExpirySeconds=jwksExpirySeconds; return (A) this;
    }

    public Boolean hasJwksExpirySeconds() {
        return this.jwksExpirySeconds != null;
    }

    public String getIntrospectionEndpointUri() {
        return this.introspectionEndpointUri;
    }

    public A withIntrospectionEndpointUri(String introspectionEndpointUri) {
        this.introspectionEndpointUri=introspectionEndpointUri; return (A) this;
    }

    public Boolean hasIntrospectionEndpointUri() {
        return this.introspectionEndpointUri != null;
    }

    public A withNewIntrospectionEndpointUri(StringBuilder arg1) {
        return (A)withIntrospectionEndpointUri(new String(arg1));
    }

    public A withNewIntrospectionEndpointUri(int[] arg1,int arg2,int arg3) {
        return (A)withIntrospectionEndpointUri(new String(arg1, arg2, arg3));
    }

    public A withNewIntrospectionEndpointUri(char[] arg1) {
        return (A)withIntrospectionEndpointUri(new String(arg1));
    }

    public A withNewIntrospectionEndpointUri(StringBuffer arg1) {
        return (A)withIntrospectionEndpointUri(new String(arg1));
    }

    public A withNewIntrospectionEndpointUri(byte[] arg1,int arg2) {
        return (A)withIntrospectionEndpointUri(new String(arg1, arg2));
    }

    public A withNewIntrospectionEndpointUri(byte[] arg1) {
        return (A)withIntrospectionEndpointUri(new String(arg1));
    }

    public A withNewIntrospectionEndpointUri(char[] arg1,int arg2,int arg3) {
        return (A)withIntrospectionEndpointUri(new String(arg1, arg2, arg3));
    }

    public A withNewIntrospectionEndpointUri(byte[] arg1,int arg2,int arg3) {
        return (A)withIntrospectionEndpointUri(new String(arg1, arg2, arg3));
    }

    public A withNewIntrospectionEndpointUri(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withIntrospectionEndpointUri(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewIntrospectionEndpointUri(String arg1) {
        return (A)withIntrospectionEndpointUri(new String(arg1));
    }

    public String getUserNameClaim() {
        return this.userNameClaim;
    }

    public A withUserNameClaim(String userNameClaim) {
        this.userNameClaim=userNameClaim; return (A) this;
    }

    public Boolean hasUserNameClaim() {
        return this.userNameClaim != null;
    }

    public A withNewUserNameClaim(StringBuilder arg1) {
        return (A)withUserNameClaim(new String(arg1));
    }

    public A withNewUserNameClaim(int[] arg1,int arg2,int arg3) {
        return (A)withUserNameClaim(new String(arg1, arg2, arg3));
    }

    public A withNewUserNameClaim(char[] arg1) {
        return (A)withUserNameClaim(new String(arg1));
    }

    public A withNewUserNameClaim(StringBuffer arg1) {
        return (A)withUserNameClaim(new String(arg1));
    }

    public A withNewUserNameClaim(byte[] arg1,int arg2) {
        return (A)withUserNameClaim(new String(arg1, arg2));
    }

    public A withNewUserNameClaim(byte[] arg1) {
        return (A)withUserNameClaim(new String(arg1));
    }

    public A withNewUserNameClaim(char[] arg1,int arg2,int arg3) {
        return (A)withUserNameClaim(new String(arg1, arg2, arg3));
    }

    public A withNewUserNameClaim(byte[] arg1,int arg2,int arg3) {
        return (A)withUserNameClaim(new String(arg1, arg2, arg3));
    }

    public A withNewUserNameClaim(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUserNameClaim(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUserNameClaim(String arg1) {
        return (A)withUserNameClaim(new String(arg1));
    }

    public String getFallbackUserNameClaim() {
        return this.fallbackUserNameClaim;
    }

    public A withFallbackUserNameClaim(String fallbackUserNameClaim) {
        this.fallbackUserNameClaim=fallbackUserNameClaim; return (A) this;
    }

    public Boolean hasFallbackUserNameClaim() {
        return this.fallbackUserNameClaim != null;
    }

    public A withNewFallbackUserNameClaim(StringBuilder arg1) {
        return (A)withFallbackUserNameClaim(new String(arg1));
    }

    public A withNewFallbackUserNameClaim(int[] arg1,int arg2,int arg3) {
        return (A)withFallbackUserNameClaim(new String(arg1, arg2, arg3));
    }

    public A withNewFallbackUserNameClaim(char[] arg1) {
        return (A)withFallbackUserNameClaim(new String(arg1));
    }

    public A withNewFallbackUserNameClaim(StringBuffer arg1) {
        return (A)withFallbackUserNameClaim(new String(arg1));
    }

    public A withNewFallbackUserNameClaim(byte[] arg1,int arg2) {
        return (A)withFallbackUserNameClaim(new String(arg1, arg2));
    }

    public A withNewFallbackUserNameClaim(byte[] arg1) {
        return (A)withFallbackUserNameClaim(new String(arg1));
    }

    public A withNewFallbackUserNameClaim(char[] arg1,int arg2,int arg3) {
        return (A)withFallbackUserNameClaim(new String(arg1, arg2, arg3));
    }

    public A withNewFallbackUserNameClaim(byte[] arg1,int arg2,int arg3) {
        return (A)withFallbackUserNameClaim(new String(arg1, arg2, arg3));
    }

    public A withNewFallbackUserNameClaim(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withFallbackUserNameClaim(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewFallbackUserNameClaim(String arg1) {
        return (A)withFallbackUserNameClaim(new String(arg1));
    }

    public String getFallbackUserNamePrefix() {
        return this.fallbackUserNamePrefix;
    }

    public A withFallbackUserNamePrefix(String fallbackUserNamePrefix) {
        this.fallbackUserNamePrefix=fallbackUserNamePrefix; return (A) this;
    }

    public Boolean hasFallbackUserNamePrefix() {
        return this.fallbackUserNamePrefix != null;
    }

    public A withNewFallbackUserNamePrefix(StringBuilder arg1) {
        return (A)withFallbackUserNamePrefix(new String(arg1));
    }

    public A withNewFallbackUserNamePrefix(int[] arg1,int arg2,int arg3) {
        return (A)withFallbackUserNamePrefix(new String(arg1, arg2, arg3));
    }

    public A withNewFallbackUserNamePrefix(char[] arg1) {
        return (A)withFallbackUserNamePrefix(new String(arg1));
    }

    public A withNewFallbackUserNamePrefix(StringBuffer arg1) {
        return (A)withFallbackUserNamePrefix(new String(arg1));
    }

    public A withNewFallbackUserNamePrefix(byte[] arg1,int arg2) {
        return (A)withFallbackUserNamePrefix(new String(arg1, arg2));
    }

    public A withNewFallbackUserNamePrefix(byte[] arg1) {
        return (A)withFallbackUserNamePrefix(new String(arg1));
    }

    public A withNewFallbackUserNamePrefix(char[] arg1,int arg2,int arg3) {
        return (A)withFallbackUserNamePrefix(new String(arg1, arg2, arg3));
    }

    public A withNewFallbackUserNamePrefix(byte[] arg1,int arg2,int arg3) {
        return (A)withFallbackUserNamePrefix(new String(arg1, arg2, arg3));
    }

    public A withNewFallbackUserNamePrefix(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withFallbackUserNamePrefix(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewFallbackUserNamePrefix(String arg1) {
        return (A)withFallbackUserNamePrefix(new String(arg1));
    }

    public String getUserInfoEndpointUri() {
        return this.userInfoEndpointUri;
    }

    public A withUserInfoEndpointUri(String userInfoEndpointUri) {
        this.userInfoEndpointUri=userInfoEndpointUri; return (A) this;
    }

    public Boolean hasUserInfoEndpointUri() {
        return this.userInfoEndpointUri != null;
    }

    public A withNewUserInfoEndpointUri(StringBuilder arg1) {
        return (A)withUserInfoEndpointUri(new String(arg1));
    }

    public A withNewUserInfoEndpointUri(int[] arg1,int arg2,int arg3) {
        return (A)withUserInfoEndpointUri(new String(arg1, arg2, arg3));
    }

    public A withNewUserInfoEndpointUri(char[] arg1) {
        return (A)withUserInfoEndpointUri(new String(arg1));
    }

    public A withNewUserInfoEndpointUri(StringBuffer arg1) {
        return (A)withUserInfoEndpointUri(new String(arg1));
    }

    public A withNewUserInfoEndpointUri(byte[] arg1,int arg2) {
        return (A)withUserInfoEndpointUri(new String(arg1, arg2));
    }

    public A withNewUserInfoEndpointUri(byte[] arg1) {
        return (A)withUserInfoEndpointUri(new String(arg1));
    }

    public A withNewUserInfoEndpointUri(char[] arg1,int arg2,int arg3) {
        return (A)withUserInfoEndpointUri(new String(arg1, arg2, arg3));
    }

    public A withNewUserInfoEndpointUri(byte[] arg1,int arg2,int arg3) {
        return (A)withUserInfoEndpointUri(new String(arg1, arg2, arg3));
    }

    public A withNewUserInfoEndpointUri(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withUserInfoEndpointUri(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewUserInfoEndpointUri(String arg1) {
        return (A)withUserInfoEndpointUri(new String(arg1));
    }

    public boolean isCheckAccessTokenType() {
        return this.checkAccessTokenType;
    }

    public A withCheckAccessTokenType(boolean checkAccessTokenType) {
        this.checkAccessTokenType=checkAccessTokenType; return (A) this;
    }

    public Boolean hasCheckAccessTokenType() {
        return true;
    }

    public String getValidTokenType() {
        return this.validTokenType;
    }

    public A withValidTokenType(String validTokenType) {
        this.validTokenType=validTokenType; return (A) this;
    }

    public Boolean hasValidTokenType() {
        return this.validTokenType != null;
    }

    public A withNewValidTokenType(StringBuilder arg1) {
        return (A)withValidTokenType(new String(arg1));
    }

    public A withNewValidTokenType(int[] arg1,int arg2,int arg3) {
        return (A)withValidTokenType(new String(arg1, arg2, arg3));
    }

    public A withNewValidTokenType(char[] arg1) {
        return (A)withValidTokenType(new String(arg1));
    }

    public A withNewValidTokenType(StringBuffer arg1) {
        return (A)withValidTokenType(new String(arg1));
    }

    public A withNewValidTokenType(byte[] arg1,int arg2) {
        return (A)withValidTokenType(new String(arg1, arg2));
    }

    public A withNewValidTokenType(byte[] arg1) {
        return (A)withValidTokenType(new String(arg1));
    }

    public A withNewValidTokenType(char[] arg1,int arg2,int arg3) {
        return (A)withValidTokenType(new String(arg1, arg2, arg3));
    }

    public A withNewValidTokenType(byte[] arg1,int arg2,int arg3) {
        return (A)withValidTokenType(new String(arg1, arg2, arg3));
    }

    public A withNewValidTokenType(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withValidTokenType(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewValidTokenType(String arg1) {
        return (A)withValidTokenType(new String(arg1));
    }

    public boolean isAccessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    public A withAccessTokenIsJwt(boolean accessTokenIsJwt) {
        this.accessTokenIsJwt=accessTokenIsJwt; return (A) this;
    }

    public Boolean hasAccessTokenIsJwt() {
        return true;
    }

    public A addToTlsTrustedCertificates(int index,CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(index >= 0 ? index : _visitables.get("tlsTrustedCertificates").size(), builder);this.tlsTrustedCertificates.add(index >= 0 ? index : tlsTrustedCertificates.size(), builder); return (A)this;
    }

    public A setToTlsTrustedCertificates(int index,CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= _visitables.get("tlsTrustedCertificates").size()) { _visitables.get("tlsTrustedCertificates").add(builder); } else { _visitables.get("tlsTrustedCertificates").set(index, builder);}
        if (index < 0 || index >= tlsTrustedCertificates.size()) { tlsTrustedCertificates.add(builder); } else { tlsTrustedCertificates.set(index, builder);}
         return (A)this;
    }

    public A addToTlsTrustedCertificates(CertSecretSource... items) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
        for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();}
        for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").add(builder);this.tlsTrustedCertificates.add(builder);} return (A)this;
    }

    public A removeFromTlsTrustedCertificates(CertSecretSource... items) {
        for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items) {
        for (CertSecretSource item : items) {CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);_visitables.get("tlsTrustedCertificates").remove(builder);if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
        if (tlsTrustedCertificates == null) return (A) this;
        final Iterator<CertSecretSourceBuilder> each = tlsTrustedCertificates.iterator();
        final List visitables = _visitables.get("tlsTrustedCertificates");
        while (each.hasNext()) {
          CertSecretSourceBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<CertSecretSource> getTlsTrustedCertificates() {
        return build(tlsTrustedCertificates);
    }

    public java.util.List<CertSecretSource> buildTlsTrustedCertificates() {
        return build(tlsTrustedCertificates);
    }

    public CertSecretSource buildTlsTrustedCertificate(int index) {
        return this.tlsTrustedCertificates.get(index).build();
    }

    public CertSecretSource buildFirstTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(0).build();
    }

    public CertSecretSource buildLastTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(tlsTrustedCertificates.size() - 1).build();
    }

    public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item: tlsTrustedCertificates) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTlsTrustedCertificates(java.util.List<CertSecretSource> tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) { _visitables.get("tlsTrustedCertificates").removeAll(this.tlsTrustedCertificates);}
        if (tlsTrustedCertificates != null) {this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>(); for (CertSecretSource item : tlsTrustedCertificates){this.addToTlsTrustedCertificates(item);}} else { this.tlsTrustedCertificates = null;} return (A) this;
    }

    public A withTlsTrustedCertificates(CertSecretSource... tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {this.tlsTrustedCertificates.clear();}
        if (tlsTrustedCertificates != null) {for (CertSecretSource item :tlsTrustedCertificates){ this.addToTlsTrustedCertificates(item);}} return (A) this;
    }

    public Boolean hasTlsTrustedCertificates() {
        return tlsTrustedCertificates != null && !tlsTrustedCertificates.isEmpty();
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
        return new TlsTrustedCertificatesNestedImpl();
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item) {
        return new TlsTrustedCertificatesNestedImpl(-1, item);
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,CertSecretSource item) {
        return new TlsTrustedCertificatesNestedImpl(index, item);
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
        if (tlsTrustedCertificates.size() <= index) throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
        return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
        if (tlsTrustedCertificates.size() == 0) throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
        return setNewTlsTrustedCertificateLike(0, buildTlsTrustedCertificate(0));
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
        int index = tlsTrustedCertificates.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
        return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i=0;i<tlsTrustedCertificates.size();i++) { 
        if (predicate.test(tlsTrustedCertificates.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
        return setNewTlsTrustedCertificateLike(index, buildTlsTrustedCertificate(index));
    }

    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification=disableTlsHostnameVerification; return (A) this;
    }

    public Boolean hasDisableTlsHostnameVerification() {
        return true;
    }

    public boolean isEnableECDSA() {
        return this.enableECDSA;
    }

    public A withEnableECDSA(boolean enableECDSA) {
        this.enableECDSA=enableECDSA; return (A) this;
    }

    public Boolean hasEnableECDSA() {
        return true;
    }

    public Integer getMaxSecondsWithoutReauthentication() {
        return this.maxSecondsWithoutReauthentication;
    }

    public A withMaxSecondsWithoutReauthentication(Integer maxSecondsWithoutReauthentication) {
        this.maxSecondsWithoutReauthentication=maxSecondsWithoutReauthentication; return (A) this;
    }

    public Boolean hasMaxSecondsWithoutReauthentication() {
        return this.maxSecondsWithoutReauthentication != null;
    }

    public boolean isEnablePlain() {
        return this.enablePlain;
    }

    public A withEnablePlain(boolean enablePlain) {
        this.enablePlain=enablePlain; return (A) this;
    }

    public Boolean hasEnablePlain() {
        return true;
    }

    public String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    public A withTokenEndpointUri(String tokenEndpointUri) {
        this.tokenEndpointUri=tokenEndpointUri; return (A) this;
    }

    public Boolean hasTokenEndpointUri() {
        return this.tokenEndpointUri != null;
    }

    public A withNewTokenEndpointUri(StringBuilder arg1) {
        return (A)withTokenEndpointUri(new String(arg1));
    }

    public A withNewTokenEndpointUri(int[] arg1,int arg2,int arg3) {
        return (A)withTokenEndpointUri(new String(arg1, arg2, arg3));
    }

    public A withNewTokenEndpointUri(char[] arg1) {
        return (A)withTokenEndpointUri(new String(arg1));
    }

    public A withNewTokenEndpointUri(StringBuffer arg1) {
        return (A)withTokenEndpointUri(new String(arg1));
    }

    public A withNewTokenEndpointUri(byte[] arg1,int arg2) {
        return (A)withTokenEndpointUri(new String(arg1, arg2));
    }

    public A withNewTokenEndpointUri(byte[] arg1) {
        return (A)withTokenEndpointUri(new String(arg1));
    }

    public A withNewTokenEndpointUri(char[] arg1,int arg2,int arg3) {
        return (A)withTokenEndpointUri(new String(arg1, arg2, arg3));
    }

    public A withNewTokenEndpointUri(byte[] arg1,int arg2,int arg3) {
        return (A)withTokenEndpointUri(new String(arg1, arg2, arg3));
    }

    public A withNewTokenEndpointUri(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withTokenEndpointUri(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewTokenEndpointUri(String arg1) {
        return (A)withTokenEndpointUri(new String(arg1));
    }

    public boolean isEnableOauthBearer() {
        return this.enableOauthBearer;
    }

    public A withEnableOauthBearer(boolean enableOauthBearer) {
        this.enableOauthBearer=enableOauthBearer; return (A) this;
    }

    public Boolean hasEnableOauthBearer() {
        return true;
    }

    public String getCustomClaimCheck() {
        return this.customClaimCheck;
    }

    public A withCustomClaimCheck(String customClaimCheck) {
        this.customClaimCheck=customClaimCheck; return (A) this;
    }

    public Boolean hasCustomClaimCheck() {
        return this.customClaimCheck != null;
    }

    public A withNewCustomClaimCheck(StringBuilder arg1) {
        return (A)withCustomClaimCheck(new String(arg1));
    }

    public A withNewCustomClaimCheck(int[] arg1,int arg2,int arg3) {
        return (A)withCustomClaimCheck(new String(arg1, arg2, arg3));
    }

    public A withNewCustomClaimCheck(char[] arg1) {
        return (A)withCustomClaimCheck(new String(arg1));
    }

    public A withNewCustomClaimCheck(StringBuffer arg1) {
        return (A)withCustomClaimCheck(new String(arg1));
    }

    public A withNewCustomClaimCheck(byte[] arg1,int arg2) {
        return (A)withCustomClaimCheck(new String(arg1, arg2));
    }

    public A withNewCustomClaimCheck(byte[] arg1) {
        return (A)withCustomClaimCheck(new String(arg1));
    }

    public A withNewCustomClaimCheck(char[] arg1,int arg2,int arg3) {
        return (A)withCustomClaimCheck(new String(arg1, arg2, arg3));
    }

    public A withNewCustomClaimCheck(byte[] arg1,int arg2,int arg3) {
        return (A)withCustomClaimCheck(new String(arg1, arg2, arg3));
    }

    public A withNewCustomClaimCheck(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCustomClaimCheck(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCustomClaimCheck(String arg1) {
        return (A)withCustomClaimCheck(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaListenerAuthenticationOAuthFluentImpl that = (KafkaListenerAuthenticationOAuthFluentImpl) o;
        if (clientId != null ? !clientId.equals(that.clientId) :that.clientId != null) return false;
        if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
        if (validIssuerUri != null ? !validIssuerUri.equals(that.validIssuerUri) :that.validIssuerUri != null) return false;
        if (checkIssuer != that.checkIssuer) return false;
        if (checkAudience != that.checkAudience) return false;
        if (jwksEndpointUri != null ? !jwksEndpointUri.equals(that.jwksEndpointUri) :that.jwksEndpointUri != null) return false;
        if (jwksRefreshSeconds != null ? !jwksRefreshSeconds.equals(that.jwksRefreshSeconds) :that.jwksRefreshSeconds != null) return false;
        if (jwksMinRefreshPauseSeconds != null ? !jwksMinRefreshPauseSeconds.equals(that.jwksMinRefreshPauseSeconds) :that.jwksMinRefreshPauseSeconds != null) return false;
        if (jwksExpirySeconds != null ? !jwksExpirySeconds.equals(that.jwksExpirySeconds) :that.jwksExpirySeconds != null) return false;
        if (introspectionEndpointUri != null ? !introspectionEndpointUri.equals(that.introspectionEndpointUri) :that.introspectionEndpointUri != null) return false;
        if (userNameClaim != null ? !userNameClaim.equals(that.userNameClaim) :that.userNameClaim != null) return false;
        if (fallbackUserNameClaim != null ? !fallbackUserNameClaim.equals(that.fallbackUserNameClaim) :that.fallbackUserNameClaim != null) return false;
        if (fallbackUserNamePrefix != null ? !fallbackUserNamePrefix.equals(that.fallbackUserNamePrefix) :that.fallbackUserNamePrefix != null) return false;
        if (userInfoEndpointUri != null ? !userInfoEndpointUri.equals(that.userInfoEndpointUri) :that.userInfoEndpointUri != null) return false;
        if (checkAccessTokenType != that.checkAccessTokenType) return false;
        if (validTokenType != null ? !validTokenType.equals(that.validTokenType) :that.validTokenType != null) return false;
        if (accessTokenIsJwt != that.accessTokenIsJwt) return false;
        if (tlsTrustedCertificates != null ? !tlsTrustedCertificates.equals(that.tlsTrustedCertificates) :that.tlsTrustedCertificates != null) return false;
        if (disableTlsHostnameVerification != that.disableTlsHostnameVerification) return false;
        if (enableECDSA != that.enableECDSA) return false;
        if (maxSecondsWithoutReauthentication != null ? !maxSecondsWithoutReauthentication.equals(that.maxSecondsWithoutReauthentication) :that.maxSecondsWithoutReauthentication != null) return false;
        if (enablePlain != that.enablePlain) return false;
        if (tokenEndpointUri != null ? !tokenEndpointUri.equals(that.tokenEndpointUri) :that.tokenEndpointUri != null) return false;
        if (enableOauthBearer != that.enableOauthBearer) return false;
        if (customClaimCheck != null ? !customClaimCheck.equals(that.customClaimCheck) :that.customClaimCheck != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clientId,  clientSecret,  validIssuerUri,  checkIssuer,  checkAudience,  jwksEndpointUri,  jwksRefreshSeconds,  jwksMinRefreshPauseSeconds,  jwksExpirySeconds,  introspectionEndpointUri,  userNameClaim,  fallbackUserNameClaim,  fallbackUserNamePrefix,  userInfoEndpointUri,  checkAccessTokenType,  validTokenType,  accessTokenIsJwt,  tlsTrustedCertificates,  disableTlsHostnameVerification,  enableECDSA,  maxSecondsWithoutReauthentication,  enablePlain,  tokenEndpointUri,  enableOauthBearer,  customClaimCheck,  super.hashCode());
    }

    public class ClientSecretNestedImpl<N> extends GenericSecretSourceFluentImpl<KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<N>> implements KafkaListenerAuthenticationOAuthFluent.ClientSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GenericSecretSourceBuilder builder;

            ClientSecretNestedImpl(GenericSecretSource item) {
                this.builder = new GenericSecretSourceBuilder(this, item);
                        
            }

            ClientSecretNestedImpl() {
                this.builder = new GenericSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaListenerAuthenticationOAuthFluentImpl.this.withClientSecret(builder.build());
            }

            public N endClientSecret() {
                return and();
            }
    }


    public class TlsTrustedCertificatesNestedImpl<N> extends CertSecretSourceFluentImpl<KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>> implements KafkaListenerAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CertSecretSourceBuilder builder;
        private final int index;

            TlsTrustedCertificatesNestedImpl(int index,CertSecretSource item) {
                this.index = index;
                this.builder = new CertSecretSourceBuilder(this, item);
                        
            }

            TlsTrustedCertificatesNestedImpl() {
                this.index = -1;
                this.builder = new CertSecretSourceBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaListenerAuthenticationOAuthFluentImpl.this.setToTlsTrustedCertificates(index,builder.build());
            }

            public N endTlsTrustedCertificate() {
                return and();
            }
    }


}
