package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaListenersBuilder extends KafkaListenersFluentImpl<KafkaListenersBuilder> implements VisitableBuilder<KafkaListeners,KafkaListenersBuilder> {

    KafkaListenersFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaListenersBuilder() {
        this(true);
    }

    public KafkaListenersBuilder(Boolean validationEnabled) {
        this(new KafkaListeners(), validationEnabled);
    }

    public KafkaListenersBuilder(KafkaListenersFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaListenersBuilder(KafkaListenersFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KafkaListeners(), validationEnabled);
    }

    public KafkaListenersBuilder(KafkaListenersFluent<?> fluent,KafkaListeners instance) {
        this(fluent, instance, true);
    }

    public KafkaListenersBuilder(KafkaListenersFluent<?> fluent,KafkaListeners instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withTls(instance.getTls());
        
        fluent.withPlain(instance.getPlain());
        
        fluent.withExternal(instance.getExternal());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaListenersBuilder(KafkaListeners instance) {
        this(instance,true);
    }

    public KafkaListenersBuilder(KafkaListeners instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withTls(instance.getTls());
        
        this.withPlain(instance.getPlain());
        
        this.withExternal(instance.getExternal());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaListeners build() {
        KafkaListeners buildable = new KafkaListeners();
        buildable.setTls(fluent.getTls());
        buildable.setPlain(fluent.getPlain());
        buildable.setExternal(fluent.getExternal());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaListenersBuilder that = (KafkaListenersBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
