package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LoadBalancerListenerBrokerOverrideBuilder extends LoadBalancerListenerBrokerOverrideFluentImpl<LoadBalancerListenerBrokerOverrideBuilder> implements VisitableBuilder<LoadBalancerListenerBrokerOverride,LoadBalancerListenerBrokerOverrideBuilder> {

    LoadBalancerListenerBrokerOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public LoadBalancerListenerBrokerOverrideBuilder() {
        this(true);
    }

    public LoadBalancerListenerBrokerOverrideBuilder(Boolean validationEnabled) {
        this(new LoadBalancerListenerBrokerOverride(), validationEnabled);
    }

    public LoadBalancerListenerBrokerOverrideBuilder(LoadBalancerListenerBrokerOverrideFluent<?> fluent) {
        this(fluent, true);
    }

    public LoadBalancerListenerBrokerOverrideBuilder(LoadBalancerListenerBrokerOverrideFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new LoadBalancerListenerBrokerOverride(), validationEnabled);
    }

    public LoadBalancerListenerBrokerOverrideBuilder(LoadBalancerListenerBrokerOverrideFluent<?> fluent,LoadBalancerListenerBrokerOverride instance) {
        this(fluent, instance, true);
    }

    public LoadBalancerListenerBrokerOverrideBuilder(LoadBalancerListenerBrokerOverrideFluent<?> fluent,LoadBalancerListenerBrokerOverride instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDnsAnnotations(instance.getDnsAnnotations());
        
        fluent.withLoadBalancerIP(instance.getLoadBalancerIP());
        
        fluent.withBroker(instance.getBroker());
        
        fluent.withAdvertisedHost(instance.getAdvertisedHost());
        
        fluent.withAdvertisedPort(instance.getAdvertisedPort());
        
        this.validationEnabled = validationEnabled; 
    }

    public LoadBalancerListenerBrokerOverrideBuilder(LoadBalancerListenerBrokerOverride instance) {
        this(instance,true);
    }

    public LoadBalancerListenerBrokerOverrideBuilder(LoadBalancerListenerBrokerOverride instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDnsAnnotations(instance.getDnsAnnotations());
        
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
        
        this.withBroker(instance.getBroker());
        
        this.withAdvertisedHost(instance.getAdvertisedHost());
        
        this.withAdvertisedPort(instance.getAdvertisedPort());
        
        this.validationEnabled = validationEnabled; 
    }

    public LoadBalancerListenerBrokerOverride build() {
        LoadBalancerListenerBrokerOverride buildable = new LoadBalancerListenerBrokerOverride();
        buildable.setBroker(fluent.getBroker());
        buildable.setAdvertisedHost(fluent.getAdvertisedHost());
        buildable.setAdvertisedPort(fluent.getAdvertisedPort());
        buildable.setDnsAnnotations(fluent.getDnsAnnotations());
        buildable.setLoadBalancerIP(fluent.getLoadBalancerIP());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LoadBalancerListenerBrokerOverrideBuilder that = (LoadBalancerListenerBrokerOverrideBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
