package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodePortListenerOverrideBuilder extends NodePortListenerOverrideFluentImpl<NodePortListenerOverrideBuilder> implements VisitableBuilder<NodePortListenerOverride,NodePortListenerOverrideBuilder> {

    NodePortListenerOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public NodePortListenerOverrideBuilder() {
        this(true);
    }

    public NodePortListenerOverrideBuilder(Boolean validationEnabled) {
        this(new NodePortListenerOverride(), validationEnabled);
    }

    public NodePortListenerOverrideBuilder(NodePortListenerOverrideFluent<?> fluent) {
        this(fluent, true);
    }

    public NodePortListenerOverrideBuilder(NodePortListenerOverrideFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new NodePortListenerOverride(), validationEnabled);
    }

    public NodePortListenerOverrideBuilder(NodePortListenerOverrideFluent<?> fluent,NodePortListenerOverride instance) {
        this(fluent, instance, true);
    }

    public NodePortListenerOverrideBuilder(NodePortListenerOverrideFluent<?> fluent,NodePortListenerOverride instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBootstrap(instance.getBootstrap());
        
        fluent.withBrokers(instance.getBrokers());
        
        this.validationEnabled = validationEnabled; 
    }

    public NodePortListenerOverrideBuilder(NodePortListenerOverride instance) {
        this(instance,true);
    }

    public NodePortListenerOverrideBuilder(NodePortListenerOverride instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withBootstrap(instance.getBootstrap());
        
        this.withBrokers(instance.getBrokers());
        
        this.validationEnabled = validationEnabled; 
    }

    public NodePortListenerOverride build() {
        NodePortListenerOverride buildable = new NodePortListenerOverride();
        buildable.setBootstrap(fluent.getBootstrap());
        buildable.setBrokers(fluent.getBrokers());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NodePortListenerOverrideBuilder that = (NodePortListenerOverrideBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
