package io.strimzi.api.kafka.model.listener.arraylistener;

import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class GenericKafkaListenerConfigurationBootstrapFluentImpl<A extends GenericKafkaListenerConfigurationBootstrapFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GenericKafkaListenerConfigurationBootstrapFluent<A> {

    private java.util.List<String> alternativeNames;
    private String host;
    private Map<String,String> annotations;
    private Map<String,String> labels;
    private Integer nodePort;
    private String loadBalancerIP;

    public GenericKafkaListenerConfigurationBootstrapFluentImpl() {
    }

    public GenericKafkaListenerConfigurationBootstrapFluentImpl(GenericKafkaListenerConfigurationBootstrap instance) {
        this.withAlternativeNames(instance.getAlternativeNames());
        
        this.withHost(instance.getHost());
        
        this.withAnnotations(instance.getAnnotations());
        
        this.withLabels(instance.getLabels());
        
        this.withNodePort(instance.getNodePort());
        
        this.withLoadBalancerIP(instance.getLoadBalancerIP());
    }

    public A addToAlternativeNames(int index,String item) {
        if (this.alternativeNames == null) {this.alternativeNames = new ArrayList<String>();}
        this.alternativeNames.add(index, item);
        return (A)this;
    }

    public A setToAlternativeNames(int index,String item) {
        if (this.alternativeNames == null) {this.alternativeNames = new ArrayList<String>();}
        this.alternativeNames.set(index, item); return (A)this;
    }

    public A addToAlternativeNames(String... items) {
        if (this.alternativeNames == null) {this.alternativeNames = new ArrayList<String>();}
        for (String item : items) {this.alternativeNames.add(item);} return (A)this;
    }

    public A addAllToAlternativeNames(Collection<String> items) {
        if (this.alternativeNames == null) {this.alternativeNames = new ArrayList<String>();}
        for (String item : items) {this.alternativeNames.add(item);} return (A)this;
    }

    public A removeFromAlternativeNames(String... items) {
        for (String item : items) {if (this.alternativeNames!= null){ this.alternativeNames.remove(item);}} return (A)this;
    }

    public A removeAllFromAlternativeNames(Collection<String> items) {
        for (String item : items) {if (this.alternativeNames!= null){ this.alternativeNames.remove(item);}} return (A)this;
    }

    public java.util.List<String> getAlternativeNames() {
        return this.alternativeNames;
    }

    public String getAlternativeName(int index) {
        return this.alternativeNames.get(index);
    }

    public String getFirstAlternativeName() {
        return this.alternativeNames.get(0);
    }

    public String getLastAlternativeName() {
        return this.alternativeNames.get(alternativeNames.size() - 1);
    }

    public String getMatchingAlternativeName(Predicate<String> predicate) {
        for (String item: alternativeNames) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingAlternativeName(Predicate<String> predicate) {
        for (String item: alternativeNames) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withAlternativeNames(java.util.List<String> alternativeNames) {
        if (this.alternativeNames != null) { _visitables.get("alternativeNames").removeAll(this.alternativeNames);}
        if (alternativeNames != null) {this.alternativeNames = new ArrayList<String>(); for (String item : alternativeNames){this.addToAlternativeNames(item);}} else { this.alternativeNames = null;} return (A) this;
    }

    public A withAlternativeNames(String... alternativeNames) {
        if (this.alternativeNames != null) {this.alternativeNames.clear();}
        if (alternativeNames != null) {for (String item :alternativeNames){ this.addToAlternativeNames(item);}} return (A) this;
    }

    public Boolean hasAlternativeNames() {
        return alternativeNames != null && !alternativeNames.isEmpty();
    }

    public A addNewAlternativeName(StringBuilder arg1) {
        return (A)addToAlternativeNames(new String(arg1));
    }

    public A addNewAlternativeName(int[] arg1,int arg2,int arg3) {
        return (A)addToAlternativeNames(new String(arg1, arg2, arg3));
    }

    public A addNewAlternativeName(char[] arg1) {
        return (A)addToAlternativeNames(new String(arg1));
    }

    public A addNewAlternativeName(StringBuffer arg1) {
        return (A)addToAlternativeNames(new String(arg1));
    }

    public A addNewAlternativeName(byte[] arg1,int arg2) {
        return (A)addToAlternativeNames(new String(arg1, arg2));
    }

    public A addNewAlternativeName(byte[] arg1) {
        return (A)addToAlternativeNames(new String(arg1));
    }

    public A addNewAlternativeName(char[] arg1,int arg2,int arg3) {
        return (A)addToAlternativeNames(new String(arg1, arg2, arg3));
    }

    public A addNewAlternativeName(byte[] arg1,int arg2,int arg3) {
        return (A)addToAlternativeNames(new String(arg1, arg2, arg3));
    }

    public A addNewAlternativeName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToAlternativeNames(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewAlternativeName(String arg1) {
        return (A)addToAlternativeNames(new String(arg1));
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host=host; return (A) this;
    }

    public Boolean hasHost() {
        return this.host != null;
    }

    public A withNewHost(StringBuilder arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(int[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(char[] arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(byte[] arg1,int arg2) {
        return (A)withHost(new String(arg1, arg2));
    }

    public A withNewHost(byte[] arg1) {
        return (A)withHost(new String(arg1));
    }

    public A withNewHost(char[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(byte[] arg1,int arg2,int arg3) {
        return (A)withHost(new String(arg1, arg2, arg3));
    }

    public A withNewHost(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withHost(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewHost(String arg1) {
        return (A)withHost(new String(arg1));
    }

    public A addToAnnotations(String key,String value) {
        if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
    }

    public A addToAnnotations(Map<String,String> map) {
        if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap<String,String>(); }
        if(map != null) { this.annotations.putAll(map);} return (A)this;
    }

    public A removeFromAnnotations(String key) {
        if(this.annotations == null) { return (A) this; }
        if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
    }

    public A removeFromAnnotations(Map<String,String> map) {
        if(this.annotations == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
    }

    public Map<String,String> getAnnotations() {
        return this.annotations;
    }

    public <K extends Object,V extends Object>A withAnnotations(Map<String,String> annotations) {
        if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap<String,String>(annotations);} return (A) this;
    }

    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    public A addToLabels(String key,String value) {
        if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
    }

    public A addToLabels(Map<String,String> map) {
        if(this.labels == null && map != null) { this.labels = new LinkedHashMap<String,String>(); }
        if(map != null) { this.labels.putAll(map);} return (A)this;
    }

    public A removeFromLabels(String key) {
        if(this.labels == null) { return (A) this; }
        if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
    }

    public A removeFromLabels(Map<String,String> map) {
        if(this.labels == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
    }

    public Map<String,String> getLabels() {
        return this.labels;
    }

    public <K extends Object,V extends Object>A withLabels(Map<String,String> labels) {
        if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap<String,String>(labels);} return (A) this;
    }

    public Boolean hasLabels() {
        return this.labels != null;
    }

    public Integer getNodePort() {
        return this.nodePort;
    }

    public A withNodePort(Integer nodePort) {
        this.nodePort=nodePort; return (A) this;
    }

    public Boolean hasNodePort() {
        return this.nodePort != null;
    }

    public String getLoadBalancerIP() {
        return this.loadBalancerIP;
    }

    public A withLoadBalancerIP(String loadBalancerIP) {
        this.loadBalancerIP=loadBalancerIP; return (A) this;
    }

    public Boolean hasLoadBalancerIP() {
        return this.loadBalancerIP != null;
    }

    public A withNewLoadBalancerIP(StringBuilder arg1) {
        return (A)withLoadBalancerIP(new String(arg1));
    }

    public A withNewLoadBalancerIP(int[] arg1,int arg2,int arg3) {
        return (A)withLoadBalancerIP(new String(arg1, arg2, arg3));
    }

    public A withNewLoadBalancerIP(char[] arg1) {
        return (A)withLoadBalancerIP(new String(arg1));
    }

    public A withNewLoadBalancerIP(StringBuffer arg1) {
        return (A)withLoadBalancerIP(new String(arg1));
    }

    public A withNewLoadBalancerIP(byte[] arg1,int arg2) {
        return (A)withLoadBalancerIP(new String(arg1, arg2));
    }

    public A withNewLoadBalancerIP(byte[] arg1) {
        return (A)withLoadBalancerIP(new String(arg1));
    }

    public A withNewLoadBalancerIP(char[] arg1,int arg2,int arg3) {
        return (A)withLoadBalancerIP(new String(arg1, arg2, arg3));
    }

    public A withNewLoadBalancerIP(byte[] arg1,int arg2,int arg3) {
        return (A)withLoadBalancerIP(new String(arg1, arg2, arg3));
    }

    public A withNewLoadBalancerIP(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withLoadBalancerIP(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewLoadBalancerIP(String arg1) {
        return (A)withLoadBalancerIP(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GenericKafkaListenerConfigurationBootstrapFluentImpl that = (GenericKafkaListenerConfigurationBootstrapFluentImpl) o;
        if (alternativeNames != null ? !alternativeNames.equals(that.alternativeNames) :that.alternativeNames != null) return false;
        if (host != null ? !host.equals(that.host) :that.host != null) return false;
        if (annotations != null ? !annotations.equals(that.annotations) :that.annotations != null) return false;
        if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
        if (nodePort != null ? !nodePort.equals(that.nodePort) :that.nodePort != null) return false;
        if (loadBalancerIP != null ? !loadBalancerIP.equals(that.loadBalancerIP) :that.loadBalancerIP != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(alternativeNames,  host,  annotations,  labels,  nodePort,  loadBalancerIP,  super.hashCode());
    }

}
