package io.strimzi.api.kafka.model.listener.arraylistener;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public interface GenericKafkaListenerConfigurationBrokerFluent<A extends GenericKafkaListenerConfigurationBrokerFluent<A>> extends Fluent<A> {


    public Integer getBroker();
    public A withBroker(Integer broker);
    public Boolean hasBroker();
    public String getAdvertisedHost();
    public A withAdvertisedHost(String advertisedHost);
    public Boolean hasAdvertisedHost();
    public A withNewAdvertisedHost(StringBuilder arg1);
    public A withNewAdvertisedHost(int[] arg1,int arg2,int arg3);
    public A withNewAdvertisedHost(char[] arg1);
    public A withNewAdvertisedHost(StringBuffer arg1);
    public A withNewAdvertisedHost(byte[] arg1,int arg2);
    public A withNewAdvertisedHost(byte[] arg1);
    public A withNewAdvertisedHost(char[] arg1,int arg2,int arg3);
    public A withNewAdvertisedHost(byte[] arg1,int arg2,int arg3);
    public A withNewAdvertisedHost(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewAdvertisedHost(String arg1);
    public Integer getAdvertisedPort();
    public A withAdvertisedPort(Integer advertisedPort);
    public Boolean hasAdvertisedPort();
    public String getHost();
    public A withHost(String host);
    public Boolean hasHost();
    public A withNewHost(StringBuilder arg1);
    public A withNewHost(int[] arg1,int arg2,int arg3);
    public A withNewHost(char[] arg1);
    public A withNewHost(StringBuffer arg1);
    public A withNewHost(byte[] arg1,int arg2);
    public A withNewHost(byte[] arg1);
    public A withNewHost(char[] arg1,int arg2,int arg3);
    public A withNewHost(byte[] arg1,int arg2,int arg3);
    public A withNewHost(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewHost(String arg1);
    public A addToAnnotations(String key,String value);
    public A addToAnnotations(Map<String,String> map);
    public A removeFromAnnotations(String key);
    public A removeFromAnnotations(Map<String,String> map);
    public Map<String,String> getAnnotations();
    public <K extends Object,V extends Object>A withAnnotations(Map<String,String> annotations);
    public Boolean hasAnnotations();
    public A addToLabels(String key,String value);
    public A addToLabels(Map<String,String> map);
    public A removeFromLabels(String key);
    public A removeFromLabels(Map<String,String> map);
    public Map<String,String> getLabels();
    public <K extends Object,V extends Object>A withLabels(Map<String,String> labels);
    public Boolean hasLabels();
    public Integer getNodePort();
    public A withNodePort(Integer nodePort);
    public Boolean hasNodePort();
    public String getLoadBalancerIP();
    public A withLoadBalancerIP(String loadBalancerIP);
    public Boolean hasLoadBalancerIP();
    public A withNewLoadBalancerIP(StringBuilder arg1);
    public A withNewLoadBalancerIP(int[] arg1,int arg2,int arg3);
    public A withNewLoadBalancerIP(char[] arg1);
    public A withNewLoadBalancerIP(StringBuffer arg1);
    public A withNewLoadBalancerIP(byte[] arg1,int arg2);
    public A withNewLoadBalancerIP(byte[] arg1);
    public A withNewLoadBalancerIP(char[] arg1,int arg2,int arg3);
    public A withNewLoadBalancerIP(byte[] arg1,int arg2,int arg3);
    public A withNewLoadBalancerIP(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewLoadBalancerIP(String arg1);
}
