package io.strimzi.api.kafka.model.listener.arraylistener;

import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuth;
import java.lang.String;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512Builder;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTls;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationOAuthFluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512FluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthentication;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationScramSha512;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationTlsFluentImpl;
import java.util.Collection;
import java.lang.Object;

public class GenericKafkaListenerFluentImpl<A extends GenericKafkaListenerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements GenericKafkaListenerFluent<A> {

    private String name;
    private int port;
    private KafkaListenerType type;
    private boolean tls;
    private VisitableBuilder<? extends KafkaListenerAuthentication,?> auth;
    private GenericKafkaListenerConfigurationBuilder configuration;
    private java.util.List<NetworkPolicyPeer> networkPolicyPeers;

    public GenericKafkaListenerFluentImpl() {
    }

    public GenericKafkaListenerFluentImpl(GenericKafkaListener instance) {
        this.withName(instance.getName());
        
        this.withPort(instance.getPort());
        
        this.withType(instance.getType());
        
        this.withTls(instance.isTls());
        
        this.withAuth(instance.getAuth());
        
        this.withConfiguration(instance.getConfiguration());
        
        this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public int getPort() {
        return this.port;
    }

    public A withPort(int port) {
        this.port=port; return (A) this;
    }

    public Boolean hasPort() {
        return true;
    }

    public KafkaListenerType getType() {
        return this.type;
    }

    public A withType(KafkaListenerType type) {
        this.type=type; return (A) this;
    }

    public Boolean hasType() {
        return this.type != null;
    }

    public boolean isTls() {
        return this.tls;
    }

    public A withTls(boolean tls) {
        this.tls=tls; return (A) this;
    }

    public Boolean hasTls() {
        return true;
    }

    
/**
 * This method has been deprecated, please use method buildAuth instead.
 * @return The buildable object.
 */
@Deprecated public KafkaListenerAuthentication getAuth() {
        return this.auth!=null?this.auth.build():null;
    }

    public KafkaListenerAuthentication buildAuth() {
        return this.auth!=null?this.auth.build():null;
    }

    public A withAuth(KafkaListenerAuthentication auth) {
        _visitables.get("auth").remove(this.auth);
        if (auth instanceof KafkaListenerAuthenticationOAuth){ this.auth= new KafkaListenerAuthenticationOAuthBuilder((KafkaListenerAuthenticationOAuth)auth); _visitables.get("auth").add(this.auth);}
        if (auth instanceof KafkaListenerAuthenticationTls){ this.auth= new KafkaListenerAuthenticationTlsBuilder((KafkaListenerAuthenticationTls)auth); _visitables.get("auth").add(this.auth);}
        if (auth instanceof KafkaListenerAuthenticationScramSha512){ this.auth= new KafkaListenerAuthenticationScramSha512Builder((KafkaListenerAuthenticationScramSha512)auth); _visitables.get("auth").add(this.auth);}
        return (A) this;
    }

    public Boolean hasAuth() {
        return this.auth != null;
    }

    public A withKafkaListenerAuthenticationOAuth(KafkaListenerAuthenticationOAuth kafkaListenerAuthenticationOAuth) {
        _visitables.get("auth").remove(this.auth);
        if (kafkaListenerAuthenticationOAuth!=null){ this.auth= new KafkaListenerAuthenticationOAuthBuilder(kafkaListenerAuthenticationOAuth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuth() {
        return new KafkaListenerAuthenticationOAuthNestedImpl();
    }

    public GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuthLike(KafkaListenerAuthenticationOAuth item) {
        return new KafkaListenerAuthenticationOAuthNestedImpl(item);
    }

    public A withKafkaListenerAuthenticationTlsAuth(KafkaListenerAuthenticationTls kafkaListenerAuthenticationTlsAuth) {
        _visitables.get("auth").remove(this.auth);
        if (kafkaListenerAuthenticationTlsAuth!=null){ this.auth= new KafkaListenerAuthenticationTlsBuilder(kafkaListenerAuthenticationTlsAuth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuth() {
        return new KafkaListenerAuthenticationTlsAuthNestedImpl();
    }

    public GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuthLike(KafkaListenerAuthenticationTls item) {
        return new KafkaListenerAuthenticationTlsAuthNestedImpl(item);
    }

    public A withKafkaListenerAuthenticationScramSha512Auth(KafkaListenerAuthenticationScramSha512 kafkaListenerAuthenticationScramSha512Auth) {
        _visitables.get("auth").remove(this.auth);
        if (kafkaListenerAuthenticationScramSha512Auth!=null){ this.auth= new KafkaListenerAuthenticationScramSha512Builder(kafkaListenerAuthenticationScramSha512Auth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512Auth() {
        return new KafkaListenerAuthenticationScramSha512AuthNestedImpl();
    }

    public GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512AuthLike(KafkaListenerAuthenticationScramSha512 item) {
        return new KafkaListenerAuthenticationScramSha512AuthNestedImpl(item);
    }

    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public GenericKafkaListenerConfiguration getConfiguration() {
        return this.configuration!=null?this.configuration.build():null;
    }

    public GenericKafkaListenerConfiguration buildConfiguration() {
        return this.configuration!=null?this.configuration.build():null;
    }

    public A withConfiguration(GenericKafkaListenerConfiguration configuration) {
        _visitables.get("configuration").remove(this.configuration);
        if (configuration!=null){ this.configuration= new GenericKafkaListenerConfigurationBuilder(configuration); _visitables.get("configuration").add(this.configuration);} return (A) this;
    }

    public Boolean hasConfiguration() {
        return this.configuration != null;
    }

    public GenericKafkaListenerFluent.ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNestedImpl();
    }

    public GenericKafkaListenerFluent.ConfigurationNested<A> withNewConfigurationLike(GenericKafkaListenerConfiguration item) {
        return new ConfigurationNestedImpl(item);
    }

    public GenericKafkaListenerFluent.ConfigurationNested<A> editConfiguration() {
        return withNewConfigurationLike(getConfiguration());
    }

    public GenericKafkaListenerFluent.ConfigurationNested<A> editOrNewConfiguration() {
        return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): new GenericKafkaListenerConfigurationBuilder().build());
    }

    public GenericKafkaListenerFluent.ConfigurationNested<A> editOrNewConfigurationLike(GenericKafkaListenerConfiguration item) {
        return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): item);
    }

    public A addToNetworkPolicyPeers(int index,NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
        this.networkPolicyPeers.add(index, item);
        return (A)this;
    }

    public A setToNetworkPolicyPeers(int index,NetworkPolicyPeer item) {
        if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
        this.networkPolicyPeers.set(index, item); return (A)this;
    }

    public A addToNetworkPolicyPeers(NetworkPolicyPeer... items) {
        if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
        for (NetworkPolicyPeer item : items) {this.networkPolicyPeers.add(item);} return (A)this;
    }

    public A addAllToNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
        if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
        for (NetworkPolicyPeer item : items) {this.networkPolicyPeers.add(item);} return (A)this;
    }

    public A removeFromNetworkPolicyPeers(NetworkPolicyPeer... items) {
        for (NetworkPolicyPeer item : items) {if (this.networkPolicyPeers!= null){ this.networkPolicyPeers.remove(item);}} return (A)this;
    }

    public A removeAllFromNetworkPolicyPeers(Collection<NetworkPolicyPeer> items) {
        for (NetworkPolicyPeer item : items) {if (this.networkPolicyPeers!= null){ this.networkPolicyPeers.remove(item);}} return (A)this;
    }

    public java.util.List<NetworkPolicyPeer> getNetworkPolicyPeers() {
        return this.networkPolicyPeers;
    }

    public NetworkPolicyPeer getNetworkPolicyPeer(int index) {
        return this.networkPolicyPeers.get(index);
    }

    public NetworkPolicyPeer getFirstNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(0);
    }

    public NetworkPolicyPeer getLastNetworkPolicyPeer() {
        return this.networkPolicyPeers.get(networkPolicyPeers.size() - 1);
    }

    public NetworkPolicyPeer getMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
        for (NetworkPolicyPeer item: networkPolicyPeers) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNetworkPolicyPeer(Predicate<NetworkPolicyPeer> predicate) {
        for (NetworkPolicyPeer item: networkPolicyPeers) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withNetworkPolicyPeers(java.util.List<NetworkPolicyPeer> networkPolicyPeers) {
        if (this.networkPolicyPeers != null) { _visitables.get("networkPolicyPeers").removeAll(this.networkPolicyPeers);}
        if (networkPolicyPeers != null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>(); for (NetworkPolicyPeer item : networkPolicyPeers){this.addToNetworkPolicyPeers(item);}} else { this.networkPolicyPeers = null;} return (A) this;
    }

    public A withNetworkPolicyPeers(NetworkPolicyPeer... networkPolicyPeers) {
        if (this.networkPolicyPeers != null) {this.networkPolicyPeers.clear();}
        if (networkPolicyPeers != null) {for (NetworkPolicyPeer item :networkPolicyPeers){ this.addToNetworkPolicyPeers(item);}} return (A) this;
    }

    public Boolean hasNetworkPolicyPeers() {
        return networkPolicyPeers != null && !networkPolicyPeers.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GenericKafkaListenerFluentImpl that = (GenericKafkaListenerFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (port != that.port) return false;
        if (type != null ? !type.equals(that.type) :that.type != null) return false;
        if (tls != that.tls) return false;
        if (auth != null ? !auth.equals(that.auth) :that.auth != null) return false;
        if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
        if (networkPolicyPeers != null ? !networkPolicyPeers.equals(that.networkPolicyPeers) :that.networkPolicyPeers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  port,  type,  tls,  auth,  configuration,  networkPolicyPeers,  super.hashCode());
    }

    public class KafkaListenerAuthenticationOAuthNestedImpl<N> extends KafkaListenerAuthenticationOAuthFluentImpl<GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<N>> implements GenericKafkaListenerFluent.KafkaListenerAuthenticationOAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaListenerAuthenticationOAuthBuilder builder;

            KafkaListenerAuthenticationOAuthNestedImpl(KafkaListenerAuthenticationOAuth item) {
                this.builder = new KafkaListenerAuthenticationOAuthBuilder(this, item);
                        
            }

            KafkaListenerAuthenticationOAuthNestedImpl() {
                this.builder = new KafkaListenerAuthenticationOAuthBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerFluentImpl.this.withAuth(builder.build());
            }

            public N endKafkaListenerAuthenticationOAuth() {
                return and();
            }
    }


    public class KafkaListenerAuthenticationTlsAuthNestedImpl<N> extends KafkaListenerAuthenticationTlsFluentImpl<GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<N>> implements GenericKafkaListenerFluent.KafkaListenerAuthenticationTlsAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaListenerAuthenticationTlsBuilder builder;

            KafkaListenerAuthenticationTlsAuthNestedImpl(KafkaListenerAuthenticationTls item) {
                this.builder = new KafkaListenerAuthenticationTlsBuilder(this, item);
                        
            }

            KafkaListenerAuthenticationTlsAuthNestedImpl() {
                this.builder = new KafkaListenerAuthenticationTlsBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerFluentImpl.this.withAuth(builder.build());
            }

            public N endKafkaListenerAuthenticationTlsAuth() {
                return and();
            }
    }


    public class KafkaListenerAuthenticationScramSha512AuthNestedImpl<N> extends KafkaListenerAuthenticationScramSha512FluentImpl<GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>> implements GenericKafkaListenerFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final KafkaListenerAuthenticationScramSha512Builder builder;

            KafkaListenerAuthenticationScramSha512AuthNestedImpl(KafkaListenerAuthenticationScramSha512 item) {
                this.builder = new KafkaListenerAuthenticationScramSha512Builder(this, item);
                        
            }

            KafkaListenerAuthenticationScramSha512AuthNestedImpl() {
                this.builder = new KafkaListenerAuthenticationScramSha512Builder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerFluentImpl.this.withAuth(builder.build());
            }

            public N endKafkaListenerAuthenticationScramSha512Auth() {
                return and();
            }
    }


    public class ConfigurationNestedImpl<N> extends GenericKafkaListenerConfigurationFluentImpl<GenericKafkaListenerFluent.ConfigurationNested<N>> implements GenericKafkaListenerFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final GenericKafkaListenerConfigurationBuilder builder;

            ConfigurationNestedImpl(GenericKafkaListenerConfiguration item) {
                this.builder = new GenericKafkaListenerConfigurationBuilder(this, item);
                        
            }

            ConfigurationNestedImpl() {
                this.builder = new GenericKafkaListenerConfigurationBuilder(this);
                        
            }

            public N and() {
                return (N) GenericKafkaListenerFluentImpl.this.withConfiguration(builder.build());
            }

            public N endConfiguration() {
                return and();
            }
    }


}
